/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.registry.IResearchEffectRegistry;
import com.minecolonies.api.research.effects.registry.ResearchEffectEntry;
import com.minecolonies.api.research.factories.IGlobalResearchFactory;
import com.minecolonies.api.research.registry.IResearchRequirementRegistry;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.research.GlobalResearch;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchFactory
implements IGlobalResearchFactory {
    @Override
    @NotNull
    public TypeToken<GlobalResearch> getFactoryOutputType() {
        return TypeToken.of(GlobalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public IGlobalResearch getNewInstance(ResourceLocation id, ResourceLocation branch, ResourceLocation parent, TranslationTextComponent desc, int universityLevel, int sortOrder, ResourceLocation iconTexture, ItemStack iconStack, TranslationTextComponent subtitle, boolean onlyChild, boolean hidden, boolean autostart, boolean instant, boolean immutable) {
        return new GlobalResearch(id, branch, parent, desc, universityLevel, sortOrder, iconTexture, iconStack, subtitle, onlyChild, hidden, autostart, instant, immutable);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull IGlobalResearch research) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("parent", research.getParent().toString());
        compound.func_74778_a("id", research.getId().toString());
        compound.func_74778_a("branch", research.getBranch().toString());
        compound.func_74778_a("name", research.getName().func_150268_i());
        compound.func_74768_a("depth", research.getDepth());
        compound.func_74768_a("sort", research.getSortOrder());
        compound.func_74757_a("onlyChild", research.hasOnlyChild());
        compound.func_74778_a("icon_tex", research.getIconTextureResourceLocation().toString());
        compound.func_74778_a("icon_is", research.getIconItemStack().func_77973_b().getRegistryName() + ":" + research.getIconItemStack().func_190916_E());
        compound.func_74778_a("subtitle", research.getSubtitle().func_150268_i());
        compound.func_74757_a("instant", research.isInstant());
        compound.func_74757_a("autostart", research.isAutostart());
        compound.func_74757_a("immutable", research.isImmutable());
        compound.func_74757_a("hidden", research.isHidden());
        @NotNull ListNBT costTagList = research.getCostList().stream().map(is -> {
            CompoundNBT costCompound = new CompoundNBT();
            costCompound.func_74778_a("cost-item", Objects.requireNonNull(is.getItem().getRegistryName()).toString() + ":" + is.getItemStack().func_190916_E());
            if (is.getItemStack().func_77978_p() != null) {
                costCompound.func_218657_a("cost-nbt", (INBT)is.getItemStack().func_77978_p());
            }
            return costCompound;
        }).collect(NBTUtils.toListNBT());
        compound.func_218657_a("cost", (INBT)costTagList);
        @NotNull ListNBT reqTagList = research.getResearchRequirement().stream().map(req -> {
            CompoundNBT reqCompound = new CompoundNBT();
            reqCompound.func_74778_a("requirement-type", req.getRegistryEntry().getRegistryName().toString());
            reqCompound.func_218657_a("requirement-item", (INBT)req.writeToNBT());
            return reqCompound;
        }).collect(NBTUtils.toListNBT());
        compound.func_218657_a("requirements", (INBT)reqTagList);
        @NotNull ListNBT effectTagList = research.getEffects().stream().map(eff -> {
            CompoundNBT effectCompound = new CompoundNBT();
            effectCompound.func_74778_a("effect-type", eff.getRegistryEntry().getRegistryName().toString());
            effectCompound.func_218657_a("effect-item", (INBT)eff.writeToNBT());
            return effectCompound;
        }).collect(NBTUtils.toListNBT());
        compound.func_218657_a("effects", (INBT)effectTagList);
        @NotNull ListNBT childTagList = research.getChildren().stream().map(child -> {
            CompoundNBT childCompound = new CompoundNBT();
            childCompound.func_74778_a("child", child.toString());
            return childCompound;
        }).collect(NBTUtils.toListNBT());
        compound.func_218657_a("hasResearchedChild", (INBT)childTagList);
        return compound;
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        ResourceLocation parent = new ResourceLocation(nbt.func_74779_i("parent"));
        ResourceLocation id = new ResourceLocation(nbt.func_74779_i("id"));
        ResourceLocation branch = new ResourceLocation(nbt.func_74779_i("branch"));
        TranslationTextComponent desc = new TranslationTextComponent(nbt.func_74779_i("name"));
        int depth = nbt.func_74762_e("depth");
        int sortOrder = nbt.func_74762_e("sort");
        boolean onlyChild = nbt.func_74767_n("onlyChild");
        ResourceLocation iconTexture = new ResourceLocation(nbt.func_74779_i("icon_tex"));
        String[] iconStackParts = nbt.func_74779_i("icon_is").split(":");
        ItemStack iconStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(iconStackParts[0], iconStackParts[1])));
        iconStack.func_190920_e(Integer.parseInt(iconStackParts[2]));
        TranslationTextComponent subtitle = new TranslationTextComponent(nbt.func_74779_i("subtitle"));
        boolean instant = nbt.func_74767_n("instant");
        boolean autostart = nbt.func_74767_n("autostart");
        boolean immutable = nbt.func_74767_n("immutable");
        boolean hidden = nbt.func_74767_n("hidden");
        IGlobalResearch research = this.getNewInstance(id, branch, parent, desc, depth, sortOrder, iconTexture, iconStack, subtitle, onlyChild, hidden, autostart, instant, immutable);
        NBTUtils.streamCompound(nbt.func_150295_c("cost", 10)).forEach(compound -> {
            String[] costParts = compound.func_74779_i("cost-item").split(":");
            if (costParts.length == 3) {
                ItemStack is = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(costParts[0], costParts[1])));
                is.func_190920_e(Integer.parseInt(costParts[2]));
                if (compound.func_186855_b("cost-nbt")) {
                    is.func_77982_d(compound.func_74775_l("cost-nbt"));
                }
                research.addCost(new ItemStorage(is, false, !is.func_77942_o()));
            }
        });
        NBTUtils.streamCompound(nbt.func_150295_c("requirements", 10)).forEach(compound -> research.addRequirement(((ResearchRequirementEntry)Objects.requireNonNull(IResearchRequirementRegistry.getInstance().getValue(ResourceLocation.func_208304_a((String)compound.func_74779_i("requirement-type"))))).readFromNBT(compound.func_74775_l("requirement-item"))));
        NBTUtils.streamCompound(nbt.func_150295_c("effects", 10)).forEach(compound -> research.addEffect(((ResearchEffectEntry)Objects.requireNonNull(IResearchEffectRegistry.getInstance().getValue(ResourceLocation.func_208304_a((String)compound.func_74779_i("effect-type"))))).readFromNBT(compound.func_74775_l("effect-item"))));
        NBTUtils.streamCompound(nbt.func_150295_c("hasResearchedChild", 10)).forEach(compound -> research.addChild(new ResourceLocation(compound.func_74779_i("child"))));
        return research;
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, IGlobalResearch input, PacketBuffer packetBuffer) {
        packetBuffer.func_192572_a(input.getParent());
        packetBuffer.func_192572_a(input.getId());
        packetBuffer.func_192572_a(input.getBranch());
        packetBuffer.func_180714_a(input.getName().func_150268_i());
        packetBuffer.func_150787_b(input.getDepth());
        packetBuffer.func_150787_b(input.getSortOrder());
        packetBuffer.writeBoolean(input.hasOnlyChild());
        packetBuffer.func_150788_a(input.getIconItemStack());
        packetBuffer.func_192572_a(input.getIconTextureResourceLocation());
        packetBuffer.func_180714_a(input.getSubtitle().func_150268_i());
        packetBuffer.writeBoolean(input.isInstant());
        packetBuffer.writeBoolean(input.isAutostart());
        packetBuffer.writeBoolean(input.isImmutable());
        packetBuffer.writeBoolean(input.isHidden());
        packetBuffer.func_150787_b(input.getCostList().size());
        for (ItemStorage itemStorage : input.getCostList()) {
            controller.serialize(packetBuffer, itemStorage);
        }
        packetBuffer.func_150787_b(input.getResearchRequirement().size());
        for (IResearchRequirement iResearchRequirement : input.getResearchRequirement()) {
            packetBuffer.func_192572_a(iResearchRequirement.getRegistryEntry().getRegistryName());
            packetBuffer.func_150786_a(iResearchRequirement.writeToNBT());
        }
        packetBuffer.func_150787_b(input.getEffects().size());
        for (IResearchEffect iResearchEffect : input.getEffects()) {
            packetBuffer.func_192572_a(iResearchEffect.getRegistryEntry().getRegistryName());
            packetBuffer.func_150786_a(iResearchEffect.writeToNBT());
        }
        packetBuffer.func_150787_b(input.getChildren().size());
        for (ResourceLocation resourceLocation : input.getChildren()) {
            packetBuffer.func_192572_a(resourceLocation);
        }
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, PacketBuffer buffer) throws Throwable {
        ResourceLocation parent = buffer.func_192575_l();
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation branch = buffer.func_192575_l();
        TranslationTextComponent desc = new TranslationTextComponent(buffer.func_218666_n());
        int depth = buffer.func_150792_a();
        int sortOrder = buffer.func_150792_a();
        boolean hasOnlyChild = buffer.readBoolean();
        ItemStack iconStack = buffer.func_150791_c();
        ResourceLocation iconTexture = buffer.func_192575_l();
        TranslationTextComponent subtitle = new TranslationTextComponent(buffer.func_218666_n());
        boolean instant = buffer.readBoolean();
        boolean autostart = buffer.readBoolean();
        boolean immutable = buffer.readBoolean();
        boolean hidden = buffer.readBoolean();
        IGlobalResearch research = this.getNewInstance(id, branch, parent, desc, depth, sortOrder, iconTexture, iconStack, subtitle, hasOnlyChild, hidden, autostart, instant, immutable);
        int costSize = buffer.func_150792_a();
        for (int i = 0; i < costSize; ++i) {
            research.addCost((ItemStorage)controller.deserialize(buffer));
        }
        int reqCount = buffer.func_150792_a();
        for (int i = 0; i < reqCount; ++i) {
            ResourceLocation reqId = buffer.func_192575_l();
            research.addRequirement(((ResearchRequirementEntry)Objects.requireNonNull(IResearchRequirementRegistry.getInstance().getValue(reqId))).readFromNBT(buffer.func_150793_b()));
        }
        int effectCount = buffer.func_150792_a();
        for (int i = 0; i < effectCount; ++i) {
            ResourceLocation effectId = buffer.func_192575_l();
            research.addEffect(((ResearchEffectEntry)Objects.requireNonNull(IResearchEffectRegistry.getInstance().getValue(effectId))).readFromNBT(buffer.func_150793_b()));
        }
        int childCount = buffer.func_150792_a();
        for (int i = 0; i < childCount; ++i) {
            research.addChild(buffer.func_192575_l());
        }
        return research;
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.GLOBAL_RESEARCH_ID;
    }
}

