/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FoodIngredient
extends Ingredient {
    public static final ResourceLocation ID = new ResourceLocation("minecolonies", "food");
    public static final String MIN_HEALING_PROP = "min-healing";
    public static final String MAX_HEALING_PROP = "max-healing";
    public static final String MIN_SATURATION_PROP = "min-saturation";
    public static final String MAX_SATURATION_PROP = "max-saturation";
    private final Optional<Integer> minHealing;
    private final Optional<Integer> maxHealing;
    private final Optional<Float> minSaturation;
    private final Optional<Float> maxSaturation;

    private FoodIngredient(Builder builder) {
        super(FoodIngredient.buildItemLists(builder));
        this.minHealing = builder.minHealing;
        this.maxHealing = builder.maxHealing;
        this.minSaturation = builder.minSaturation;
        this.maxSaturation = builder.maxSaturation;
    }

    private static Stream<Ingredient.IItemList> buildItemLists(Builder builder) {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(ItemStackUtils.ISFOOD).filter(x$0 -> builder.matchesFood(x$0)).map(Ingredient.SingleItemList::new);
    }

    @NotNull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        Serializer.getInstance().write(json, this);
        return json;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.getInstance();
    }

    public static class Serializer
    implements IIngredientSerializer<FoodIngredient> {
        private static final Serializer INSTANCE = new Serializer();

        public static Serializer getInstance() {
            return INSTANCE;
        }

        private Serializer() {
        }

        @NotNull
        public FoodIngredient parse(@NotNull JsonObject json) {
            Builder builder = new Builder();
            if (json.has(FoodIngredient.MIN_HEALING_PROP)) {
                builder.minHealing(JSONUtils.func_151203_m((JsonObject)json, (String)FoodIngredient.MIN_HEALING_PROP));
            }
            if (json.has(FoodIngredient.MAX_HEALING_PROP)) {
                builder.maxHealing(JSONUtils.func_151203_m((JsonObject)json, (String)FoodIngredient.MAX_HEALING_PROP));
            }
            if (json.has(FoodIngredient.MIN_SATURATION_PROP)) {
                builder.minSaturation(JSONUtils.func_151217_k((JsonObject)json, (String)FoodIngredient.MIN_SATURATION_PROP));
            }
            if (json.has(FoodIngredient.MAX_SATURATION_PROP)) {
                builder.maxSaturation(JSONUtils.func_151217_k((JsonObject)json, (String)FoodIngredient.MAX_SATURATION_PROP));
            }
            return builder.build();
        }

        public void write(@NotNull JsonObject json, @NotNull FoodIngredient ingredient) {
            json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)this)).toString());
            ingredient.minHealing.ifPresent(value -> json.addProperty(FoodIngredient.MIN_HEALING_PROP, (Number)value));
            ingredient.maxHealing.ifPresent(value -> json.addProperty(FoodIngredient.MAX_HEALING_PROP, (Number)value));
            ingredient.minSaturation.ifPresent(value -> json.addProperty(FoodIngredient.MIN_SATURATION_PROP, (Number)value));
            ingredient.maxSaturation.ifPresent(value -> json.addProperty(FoodIngredient.MAX_SATURATION_PROP, (Number)value));
        }

        @NotNull
        public FoodIngredient parse(@NotNull PacketBuffer buffer) {
            Builder builder = new Builder();
            int flags = buffer.func_150792_a();
            if ((flags & 1) != 0) {
                builder.minHealing(buffer.func_150792_a());
            }
            if ((flags & 2) != 0) {
                builder.maxHealing(buffer.func_150792_a());
            }
            if ((flags & 4) != 0) {
                builder.minSaturation(buffer.readFloat());
            }
            if ((flags & 8) != 0) {
                builder.maxSaturation(buffer.readFloat());
            }
            return builder.build();
        }

        public void write(@NotNull PacketBuffer buffer, @NotNull FoodIngredient ingredient) {
            buffer.func_150787_b((ingredient.minHealing.isPresent() ? 1 : 0) | (ingredient.maxHealing.isPresent() ? 2 : 0) | (ingredient.minSaturation.isPresent() ? 4 : 0) | (ingredient.maxSaturation.isPresent() ? 8 : 0));
            ingredient.minHealing.ifPresent(arg_0 -> ((PacketBuffer)buffer).func_150787_b(arg_0));
            ingredient.maxHealing.ifPresent(arg_0 -> ((PacketBuffer)buffer).func_150787_b(arg_0));
            ingredient.minSaturation.ifPresent(arg_0 -> ((PacketBuffer)buffer).writeFloat(arg_0));
            ingredient.maxSaturation.ifPresent(arg_0 -> ((PacketBuffer)buffer).writeFloat(arg_0));
        }
    }

    public static class Builder {
        private Optional<Integer> minHealing = Optional.empty();
        private Optional<Integer> maxHealing = Optional.empty();
        private Optional<Float> minSaturation = Optional.empty();
        private Optional<Float> maxSaturation = Optional.empty();

        public Builder minHealing(int healing) {
            this.minHealing = Optional.of(healing);
            return this;
        }

        public Builder maxHealing(int healing) {
            this.maxHealing = Optional.of(healing);
            return this;
        }

        public Builder minSaturation(float saturation) {
            this.minSaturation = Optional.of(Float.valueOf(saturation));
            return this;
        }

        public Builder maxSaturation(float saturation) {
            this.maxSaturation = Optional.of(Float.valueOf(saturation));
            return this;
        }

        public FoodIngredient build() {
            return new FoodIngredient(this);
        }

        private boolean matchesFood(@NotNull ItemStack stack) {
            @NotNull Food food = Objects.requireNonNull(stack.func_77973_b().func_219967_s());
            return this.minHealing.map(healing -> food.func_221466_a() >= healing).orElse(true) != false && this.maxHealing.map(healing -> food.func_221466_a() < healing).orElse(true) != false && this.minSaturation.map(saturation -> food.func_221469_b() >= saturation.floatValue()).orElse(true) != false && this.maxSaturation.map(saturation -> food.func_221469_b() < saturation.floatValue()).orElse(true) != false;
        }
    }
}

