/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AddRemoveRecipeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private boolean remove;
    private IRecipeStorage storage;
    private String id;

    public AddRemoveRecipeMessage() {
    }

    public AddRemoveRecipeMessage(IBuildingView building, boolean remove, IRecipeStorage storage, String id) {
        super(building);
        this.remove = remove;
        this.storage = storage;
        this.id = id;
    }

    public AddRemoveRecipeMessage(IBuildingView building, List<ItemStorage> input, int gridSize, ItemStack primaryOutput, List<ItemStack> additionalOutputs, boolean remove, String id) {
        super(building);
        this.remove = remove;
        this.storage = gridSize == 1 ? (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.field_150460_al}) : (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.field_150350_a, null, null, null, additionalOutputs});
        this.id = id;
    }

    public AddRemoveRecipeMessage(IBuildingView building, List<ItemStorage> input, int gridSize, ItemStack primaryOutput, boolean remove, Block intermediary, String id) {
        super(building);
        this.remove = remove;
        if (gridSize == 1) {
            this.storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, intermediary});
        }
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf);
        this.remove = buf.readBoolean();
        this.id = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        StandardFactoryController.getInstance().serialize(buf, this.storage);
        buf.writeBoolean(this.remove);
        buf.func_180714_a(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        AbstractCraftingBuildingModule module = building.getModuleMatching(AbstractCraftingBuildingModule.class, m -> m.getId().equals(this.id));
        if (this.remove) {
            module.removeRecipe(this.storage.getToken());
            SoundUtils.playSuccessSound((PlayerEntity)player, player.func_233580_cy_());
        } else {
            IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(this.storage);
            if (!module.addRecipe(token)) {
                SoundUtils.playErrorSound((PlayerEntity)player, player.func_233580_cy_());
                MessageUtils.format("com.minecolonies.coremod.recipe.unable", new TranslationTextComponent(building.getBuildingDisplayName())).sendTo(new PlayerEntity[]{player});
            } else {
                SoundUtils.playSuccessSound((PlayerEntity)player, player.func_233580_cy_());
                AdvancementUtils.TriggerAdvancementPlayersForColony(colony, playerMP -> AdvancementTriggers.BUILDING_ADD_RECIPE.trigger((ServerPlayerEntity)playerMP, this.storage));
                MessageUtils.format("com.minecolonies.coremod.gui.recipe.done", new Object[0]).sendTo(new PlayerEntity[]{player});
            }
        }
        building.markDirty();
    }
}

