/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class TransferItemsRequestMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private ItemStack itemStack;
    private int quantity;
    private boolean attemptResolve;

    public TransferItemsRequestMessage() {
    }

    public TransferItemsRequestMessage(@NotNull IBuildingView building, ItemStack itemStack, int quantity, boolean attemptResolve) {
        super(building);
        this.itemStack = itemStack;
        this.quantity = quantity;
        this.attemptResolve = attemptResolve;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.itemStack = buf.func_150791_c();
        this.quantity = buf.readInt();
        this.attemptResolve = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_150788_a(this.itemStack);
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.attemptResolve);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        int amountToTake;
        if (this.quantity <= 0) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        boolean isCreative = player.func_184812_l_();
        Map<ItemStorage, ItemStorage> previousContent = null;
        if (isCreative) {
            amountToTake = this.quantity;
        } else {
            if (((Boolean)MineColonies.getConfig().getServer().debugInventories.get()).booleanValue()) {
                previousContent = InventoryUtils.getAllItemsForProviders((ICapabilityProvider)building.getTileEntity(), new IItemHandler[]{new InvWrapper((IInventory)player.field_71071_by)});
            }
            amountToTake = Math.min(this.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack, true, true)));
        }
        ItemStack remainingItemStack = ItemStack.field_190927_a;
        int tempAmount = amountToTake;
        int i = 0;
        while ((double)i < Math.max(1.0, Math.ceil((double)amountToTake / (double)this.itemStack.func_77976_d()))) {
            ItemStack itemStackToTake = this.itemStack.func_77946_l();
            int insertAmount = Math.min(this.itemStack.func_77976_d(), tempAmount);
            itemStackToTake.func_190920_e(insertAmount);
            tempAmount -= insertAmount;
            remainingItemStack = InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)building.getTileEntity(), itemStackToTake);
            if (!remainingItemStack.func_190926_b()) {
                tempAmount += remainingItemStack.func_190916_E();
                break;
            }
            ++i;
        }
        if (ItemStackUtils.isEmpty(remainingItemStack).booleanValue() || ItemStackUtils.getSize(remainingItemStack) != amountToTake) {
            building.getTileEntity().func_70296_d();
        }
        if (ItemStackUtils.isEmpty(remainingItemStack).booleanValue() || ItemStackUtils.getSize(remainingItemStack) != amountToTake) {
            if (!isCreative) {
                ItemStack itemsTaken;
                for (int amountToRemoveFromPlayer = amountToTake - tempAmount; amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                    int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack, true, true));
                    itemsTaken = player.field_71071_by.func_70298_a(slot, amountToRemoveFromPlayer);
                }
            }
            if (this.attemptResolve) {
                building.overruleNextOpenRequestWithStack(this.itemStack);
            }
        }
        if (!isCreative && previousContent != null && ((Boolean)MineColonies.getConfig().getServer().debugInventories.get()).booleanValue()) {
            InventoryUtils.doStorageSetsMatch(previousContent, InventoryUtils.getAllItemsForProviders((ICapabilityProvider)building.getTileEntity(), new IItemHandler[]{new InvWrapper((IInventory)player.field_71071_by)}), true);
        }
    }
}

