/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class HireFireMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private boolean hire;
    private int citizenID;
    private JobEntry entry;

    public HireFireMessage() {
    }

    public HireFireMessage(@NotNull IBuildingView building, boolean hire, int citizenID, JobEntry entry) {
        super(building);
        this.hire = hire;
        this.citizenID = citizenID;
        this.entry = entry;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.hire = buf.readBoolean();
        this.citizenID = buf.readInt();
        this.entry = (JobEntry)buf.readRegistryId();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.hire);
        buf.writeInt(this.citizenID);
        buf.writeRegistryId((IForgeRegistryEntry)this.entry);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
        citizen.setPaused(false);
        if (this.hire) {
            building.getModuleMatching(IAssignsJob.class, m -> m.getJobEntry() == this.entry).assignCitizen(citizen);
        } else {
            building.getModuleMatching(IAssignsJob.class, m -> m.getJobEntry() == this.entry).removeCitizen(citizen);
        }
    }
}

