/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.network.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewBuildingViewMessage
implements IMessage {
    private int colonyId;
    private BlockPos buildingId;
    private PacketBuffer buildingData;
    private RegistryKey<World> dimension;

    public ColonyViewBuildingViewMessage() {
    }

    public ColonyViewBuildingViewMessage(@NotNull IBuilding building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.buildingData = new PacketBuffer(Unpooled.buffer());
        building.serializeToView(this.buildingData);
        this.dimension = building.getColony().getDimension();
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.colonyId = buf.readInt();
        this.buildingId = buf.func_179259_c();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        this.buildingData = new PacketBuffer(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.buildingData, buf.readableBytes());
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.func_179255_a(this.buildingId);
        buf.func_180714_a(this.dimension.func_240901_a_().toString());
        buf.writeBytes((ByteBuf)this.buildingData);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyBuildingViewMessage(this.colonyId, this.buildingId, this.buildingData, this.dimension);
    }
}

