/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamParticleEffectMessage
implements IMessage {
    private static final Random RAND = new Random();
    private BasicParticleType type;
    private double sPosX;
    private double sPosY;
    private double sPosZ;
    private double ePosX;
    private double ePosY;
    private double ePosZ;
    private int stage;
    private int maxStage;

    public StreamParticleEffectMessage() {
    }

    public StreamParticleEffectMessage(Vector3d start, Vector3d end, BasicParticleType type, int stage, int maxStage) {
        this.sPosX = start.field_72450_a;
        this.sPosY = start.field_72448_b - 0.5;
        this.sPosZ = start.field_72449_c;
        this.ePosX = end.field_72450_a;
        this.ePosY = end.field_72448_b - 0.5;
        this.ePosZ = end.field_72449_c;
        this.stage = stage;
        this.maxStage = maxStage;
        this.type = type;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.sPosX = buf.readDouble();
        this.sPosY = buf.readDouble();
        this.sPosZ = buf.readDouble();
        this.ePosX = buf.readDouble();
        this.ePosY = buf.readDouble();
        this.ePosZ = buf.readDouble();
        this.stage = buf.readInt();
        this.maxStage = buf.readInt();
        this.type = (BasicParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buf.func_192575_l());
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeDouble(this.sPosX);
        buf.writeDouble(this.sPosY);
        buf.writeDouble(this.sPosZ);
        buf.writeDouble(this.ePosX);
        buf.writeDouble(this.ePosY);
        buf.writeDouble(this.ePosZ);
        buf.writeInt(this.stage);
        buf.writeInt(this.maxStage);
        buf.func_192572_a(this.type.getRegistryName());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Vector3d end = new Vector3d(this.ePosX, this.ePosY, this.ePosZ);
        double xDif = (this.sPosX - this.ePosX) / (double)this.maxStage;
        double yDif = (this.sPosY - this.ePosY) / (double)this.maxStage;
        double zDif = (this.sPosZ - this.ePosZ) / (double)this.maxStage;
        double curve = (double)this.maxStage / 3.0;
        for (int step = Math.max(0, this.stage - 1); step <= Math.min(this.maxStage, this.stage + 1); ++step) {
            double minDif = (double)Math.min(step, Math.abs(step - this.maxStage)) / curve;
            for (int i = 0; i < 10; ++i) {
                Vector3d randomPos = new Vector3d(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
                Vector3d randomOffset = new Vector3d((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
                world.func_195594_a((IParticleData)this.type, end.field_72450_a + randomOffset.field_72450_a + xDif * (double)step, end.field_72448_b + randomOffset.field_72448_b + yDif * (double)step + minDif, end.field_72449_c + randomOffset.field_72449_c + zDif * (double)step, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c);
            }
        }
    }
}

