/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemParticleEffectMessage
implements IMessage {
    private static final Random RAND = new Random();
    private ItemStack stack;
    private double rotationPitch;
    private double rotationYaw;
    private double eyeHeight;
    private double posX;
    private double posY;
    private double posZ;

    public ItemParticleEffectMessage() {
    }

    public ItemParticleEffectMessage(ItemStack stack, double posX, double posY, double posZ, double rotationPitch, double rotationYaw, double eyeHeight) {
        this.stack = stack;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.rotationPitch = rotationPitch;
        this.rotationYaw = rotationYaw;
        this.eyeHeight = eyeHeight;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.stack = buf.func_150791_c();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.rotationPitch = buf.readDouble();
        this.rotationYaw = buf.readDouble();
        this.eyeHeight = buf.readDouble();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_150788_a(this.stack);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.rotationPitch);
        buf.writeDouble(this.rotationYaw);
        buf.writeDouble(this.eyeHeight);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ItemStack localStack = this.stack;
        if (localStack.func_77975_n() == UseAction.EAT) {
            for (int i = 0; i < 5; ++i) {
                Vector3d randomPos = new Vector3d((RAND.nextDouble() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                randomPos = randomPos.func_178789_a((float)(-this.rotationPitch * 0.01745329238474369));
                randomPos = randomPos.func_178785_b((float)(-this.rotationYaw * 0.01745329238474369));
                double d0 = -RAND.nextDouble() * 0.6 - 0.3;
                Vector3d randomOffset = new Vector3d((RAND.nextDouble() - 0.5) * 0.3, d0, 0.6);
                randomOffset = randomOffset.func_178789_a((float)(-this.rotationPitch * 0.01745329238474369));
                randomOffset = randomOffset.func_178785_b((float)(-this.rotationYaw * 0.01745329238474369));
                randomOffset = randomOffset.func_72441_c(this.posX, this.posY + this.eyeHeight, this.posZ);
                world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, localStack), randomOffset.field_72450_a, randomOffset.field_72448_b, randomOffset.field_72449_c, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c);
            }
        }
    }
}

