/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.google.common.collect.Lists;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import com.ldtteam.structurize.blocks.types.TimberFrameCentreType;
import com.ldtteam.structurize.blocks.types.TimberFrameType;
import com.ldtteam.structurize.blocks.types.WoodType;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SawmillTimberFrameRecipeProvider
extends CustomRecipeProvider {
    public SawmillTimberFrameRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @NotNull
    public String func_200397_b() {
        return "SawmillTimberFrameRecipeProvider";
    }

    @Override
    protected void registerRecipes(Consumer<IFinishedRecipe> consumer) {
        for (WoodType frameType : WoodType.values()) {
            for (TimberFrameCentreType centreType : TimberFrameCentreType.values()) {
                String id = String.format("%s_%s_timber_frame", frameType.func_176610_l(), centreType.func_176610_l());
                ItemStorage frame = new ItemStorage(new ItemStack((IItemProvider)frameType.getMaterial(), 1));
                ItemStorage centre = new ItemStorage(new ItemStack(centreType.getMaterial()));
                List results = Arrays.stream(TimberFrameType.values()).map(type -> SawmillTimberFrameRecipeProvider.idToStructurize(BlockTimberFrame.getName((TimberFrameType)type, (WoodType)frameType, (TimberFrameCentreType)centreType), 4)).collect(Collectors.toList());
                CustomRecipeProvider.CustomRecipeBuilder.create("sawmill_crafting", id).inputs(Lists.newArrayList((Object[])new ItemStorage[]{frame, centre, new ItemStorage(new ItemStack((IItemProvider)ModItems.buildTool.get()))})).alternateOutputs(results.subList(1, results.size())).result((ItemStack)results.get(0)).mustExist(true).build(consumer);
            }
        }
    }

    private static ItemStack idToStructurize(String name, int count) {
        return SawmillTimberFrameRecipeProvider.idToStack(new ResourceLocation("structurize", name), count);
    }

    private static ItemStack idToStack(ResourceLocation id, int count) {
        return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(id), count);
    }
}

