/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DefaultNetherWorkerLootProvider
implements IDataProvider {
    private static final int MAX_BUILDING_LEVEL = 5;
    private final NetherWorkerRecipeProvider recipeProvider;
    private final NetherWorkerLootTableProvider lootTableProvider;
    private final List<LootTable.Builder> levels = new ArrayList<LootTable.Builder>();

    public DefaultNetherWorkerLootProvider(@NotNull DataGenerator generatorIn, @NotNull LootTableManager lootTableManager) {
        for (int buildingLevel = 1; buildingLevel <= 5; ++buildingLevel) {
            this.levels.add(this.createTripLoot(buildingLevel));
        }
        this.recipeProvider = new NetherWorkerRecipeProvider(generatorIn, lootTableManager);
        this.lootTableProvider = new NetherWorkerLootTableProvider(generatorIn);
    }

    private LootTable.Builder createTripLoot(int buildingLevel) {
        return new LootTable.Builder().func_216040_a(this.createBlocksPool(buildingLevel)).func_216040_a(this.createMobsPool(buildingLevel));
    }

    @NotNull
    private LootPool.Builder createBlocksPool(int buildingLevel) {
        LootPool.Builder blocks = new LootPool.Builder().name("blocks").func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)10.0f)).bonusRolls(0.3f, 0.3f);
        blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221691_cH).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)25.0f))));
        blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221693_cI).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)7.0f))));
        blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234734_dm_).func_216086_a(8).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f))));
        blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221550_C).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)10.0f))));
        blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221860_en).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))));
        if (buildingLevel >= 2) {
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221695_cJ).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151075_bm).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221692_bh).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221694_bi).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234767_m_).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234722_bw_).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234709_R_).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))));
        }
        if (buildingLevel >= 3) {
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234735_dn_).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234768_n_).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234723_bx_).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234710_S_).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))));
        }
        if (buildingLevel >= 4) {
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234708_K_).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))));
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234777_rA_).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))));
        }
        if (buildingLevel >= 5) {
            blocks.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_234795_rx_).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))));
        }
        return blocks;
    }

    @NotNull
    private LootPool.Builder createMobsPool(int buildingLevel) {
        LootPool.Builder mobs = new LootPool.Builder().name("mobs").func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)6.0f)).bonusRolls(0.1f, 0.1f);
        mobs.func_216045_a((LootEntry.Builder)this.createAdventureToken(EntityType.field_233592_ba_, 5, 5).func_216086_a(5500).func_216085_b(-10));
        mobs.func_216045_a((LootEntry.Builder)this.createAdventureToken(EntityType.field_200771_K, 3, 4).func_216086_a(300).func_216085_b(10));
        mobs.func_216045_a((LootEntry.Builder)this.createAdventureToken(EntityType.field_233588_G_, 3, 5).func_216086_a(500).func_216085_b(-1));
        mobs.func_216045_a((LootEntry.Builder)this.createAdventureToken(EntityType.field_200811_y, 12, 5).func_216086_a(300).func_216085_b(-3));
        mobs.func_216045_a((LootEntry.Builder)this.createAdventureToken(EntityType.field_200803_q, 7, 5).func_216086_a(300).func_216085_b(-3));
        mobs.func_216045_a((LootEntry.Builder)this.createAdventureToken(EntityType.field_200792_f, 5, 10).func_216086_a(100).func_216085_b(1));
        return mobs;
    }

    @NotNull
    private StandaloneLootEntry.Builder<?> createAdventureToken(@NotNull EntityType<?> mob, int damage_done, int xp_gained) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("entity-type", mob.getRegistryName().toString());
        nbt.func_74768_a("damage-done", damage_done);
        nbt.func_74768_a("xp-dropped", xp_gained);
        ItemStack stack = new ItemStack((IItemProvider)ModItems.adventureToken);
        stack.func_77982_d(nbt);
        return SimpleLootTableProvider.itemStack(stack);
    }

    @NotNull
    public String func_200397_b() {
        return "NetherWorkerLootProvider";
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        this.recipeProvider.func_200398_a(cache);
        this.lootTableProvider.func_200398_a(cache);
    }

    private class NetherWorkerLootTableProvider
    extends SimpleLootTableProvider {
        public NetherWorkerLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @NotNull
        public String func_200397_b() {
            return "NetherWorkerLootTableProvider";
        }

        @Override
        protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
            for (int i = 0; i < DefaultNetherWorkerLootProvider.this.levels.size(); ++i) {
                int buildingLevel = i + 1;
                LootTable.Builder lootTable = (LootTable.Builder)DefaultNetherWorkerLootProvider.this.levels.get(i);
                registrar.register(new ResourceLocation("minecolonies", "recipes/" + ModJobs.NETHERWORKER_ID.func_110623_a() + "/trip" + buildingLevel), LootParameterSets.field_216266_g, lootTable);
            }
        }
    }

    private class NetherWorkerRecipeProvider
    extends CustomRecipeProvider {
        private final LootTableManager lootTableManager;

        public NetherWorkerRecipeProvider(@NotNull DataGenerator generatorIn, LootTableManager lootTableManager) {
            super(generatorIn);
            this.lootTableManager = lootTableManager;
        }

        @NotNull
        public String func_200397_b() {
            return "NetherWorkerRecipeProvider";
        }

        @Override
        protected void registerRecipes(@NotNull Consumer<IFinishedRecipe> consumer) {
            List<ItemStorage> inputs = Arrays.asList(new ItemStorage(new ItemStack((IItemProvider)Items.field_221585_m, 64)), new ItemStorage(new ItemStack((IItemProvider)Items.field_221657_bQ, 32)), new ItemStorage(new ItemStack((IItemProvider)Items.field_221740_cf, 16)));
            for (int i = 0; i < DefaultNetherWorkerLootProvider.this.levels.size(); ++i) {
                int buildingLevel = i + 1;
                List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops(this.lootTableManager, ((LootTable.Builder)DefaultNetherWorkerLootProvider.this.levels.get(i)).func_216038_b());
                Stream<ItemStack> loot = drops.stream().flatMap(drop -> drop.getItemStacks().stream().map(ItemStack::func_77973_b));
                CustomRecipeProvider.CustomRecipeBuilder.create(ModJobs.NETHERWORKER_ID.func_110623_a() + "_custom", "trip" + buildingLevel).minBuildingLevel(buildingLevel).maxBuildingLevel(buildingLevel).inputs(inputs).secondaryOutputs(loot.map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + ModJobs.NETHERWORKER_ID.func_110623_a() + "/trip" + buildingLevel)).build(consumer);
            }
            CustomRecipeProvider.CustomRecipeBuilder.create(ModJobs.NETHERWORKER_ID.func_110623_a() + "_custom", "lava").inputs(Collections.singletonList(new ItemStorage(new ItemStack((IItemProvider)Items.field_151133_ar)))).result(new ItemStack((IItemProvider)Items.field_151129_at)).build(consumer);
        }
    }
}

