/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
extends SimpleLootTableProvider {
    public DefaultBlockLootTableProvider(@NotNull DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @NotNull
    public String func_200397_b() {
        return "Default Block Loot Table Provider";
    }

    @Override
    protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        this.saveBlocks(Arrays.asList(ModBlocks.getHuts()), registrar);
        this.saveBlock(ModBlocks.blockHutWareHouse, registrar);
        this.saveBlock(ModBlocks.blockStash, registrar);
        this.saveBlock((Block)ModBlocks.blockConstructionTape, registrar);
        this.saveBlock(ModBlocks.blockRack, registrar);
        this.saveBlock(ModBlocks.blockWayPoint, registrar);
        this.saveBlock((Block)ModBlocks.blockBarrel, registrar);
        this.saveBlock((Block)ModBlocks.blockDecorationPlaceholder, registrar);
        this.saveBlock(ModBlocks.blockScarecrow, registrar);
        this.saveBlock((Block)ModBlocks.blockColonyBanner, registrar);
        this.saveBlock((Block)ModBlocks.blockIronGate, registrar);
        this.saveBlock((Block)ModBlocks.blockWoodenGate, registrar);
    }

    private <T extends Block> void saveBlocks(@NotNull List<T> blocks, @NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        for (Block block : blocks) {
            this.saveBlock(block, registrar);
        }
    }

    private void saveBlock(@NotNull Block block, @NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        if (block.getRegistryName() != null) {
            ResourceLocation id = new ResourceLocation(block.getRegistryName().func_110624_b(), "blocks/" + block.getRegistryName().func_110623_a());
            StandaloneLootEntry.Builder item = ItemLootEntry.func_216168_a((IItemProvider)block);
            if (block instanceof AbstractBlockHut || block instanceof BlockMinecoloniesRack) {
                item.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY));
            }
            registrar.register(id, LootParameterSets.field_216267_h, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)item).func_212840_b_(SurvivesExplosion.func_215968_b())));
        }
    }
}

