/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ldtteam.blockout.Log;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.StructureClientHandler;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.RenderUtils;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.event.DebugRendererChunkBorder;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.antlr.v4.runtime.misc.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final String MOB_SOUND_EVENT_PREFIX = "mob.";
    private static final double PREVIEW_RANGE = 25.0;
    private static Blueprint wayPointTemplate;
    private static Blueprint partolPointTemplate;
    private static Map<BlockPos, Triple<Blueprint, BlockPos, BlockPos>> blueprintCache;
    public static final RenderTypeBuffers renderBuffers;
    private static final IRenderTypeBuffer.Impl renderBuffer;
    private static final Supplier<IVertexBuilder> linesWithCullAndDepth;
    private static final Supplier<IVertexBuilder> linesWithoutCullAndDepth;
    private static final Lazy<Map<String, BuildingEntry>> crafterToBuilding;
    public static Set<String> alreadyRequestedStructures;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        Pathfinding.debugDraw(event.getPartialTicks(), event.getMatrixStack());
        Blueprint structure = Settings.instance.getActiveStructure();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (structure != null) {
            ClientEventHandler.handleRenderStructure(event, world, (PlayerEntity)player);
        }
        if (player.func_184614_ca().func_77973_b() == com.minecolonies.api.items.ModItems.scepterGuard) {
            ClientEventHandler.handleRenderScepterGuard(event, world, (PlayerEntity)player);
        } else if (player.func_184614_ca().func_77973_b() == com.minecolonies.api.items.ModItems.bannerRallyGuards) {
            ClientEventHandler.handleRenderBannerRallyGuards(event, world, (PlayerEntity)player);
        } else if (player.func_184614_ca().func_77973_b() == ModItems.buildTool.get()) {
            ClientEventHandler.handleRenderBuildTool(event, world, (PlayerEntity)player);
        } else {
            alreadyRequestedStructures.clear();
        }
        DebugRendererChunkBorder.renderWorldLastEvent(event);
        renderBuffer.func_228461_a_();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        if (event.getSound().func_147650_b().func_110624_b().equals("minecolonies") && !((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getClient().citizenVoices.get()).booleanValue()) {
            String path = event.getSound().func_147650_b().func_110623_a();
            if (!path.startsWith(MOB_SOUND_EVENT_PREFIX)) {
                return;
            }
            int secondDotPos = path.indexOf(46, MOB_SOUND_EVENT_PREFIX.length());
            if (secondDotPos == -1) {
                return;
            }
            String mobName = path.substring(MOB_SOUND_EVENT_PREFIX.length(), secondDotPos);
            if (ModSoundEvents.CITIZEN_SOUND_EVENTS.containsKey(mobName)) {
                event.setResultSound(null);
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        BlockItem blockItem;
        if (event.getPlayer() == null) {
            return;
        }
        IColony colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColony(event.getPlayer().field_70170_p, event.getPlayer().func_233580_cy_());
        if (colony == null) {
            colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColonyByOwner(event.getPlayer().field_70170_p, event.getPlayer());
        }
        ClientEventHandler.handleCrafterRecipeTooltips(colony, event.getToolTip(), event.getItemStack().func_77973_b());
        if (event.getItemStack().func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)event.getItemStack().func_77973_b()).func_179223_d() instanceof AbstractBlockHut) {
            ClientEventHandler.handleHutBlockResearchUnlocks(colony, event.getToolTip(), blockItem.func_179223_d());
        }
    }

    private static void handleCrafterRecipeTooltips(@Nullable IColony colony, List<ITextComponent> toolTip, Item item) {
        List<CustomRecipe> recipes = CustomRecipeManager.getInstance().getRecipeByOutput(item);
        if (recipes.isEmpty()) {
            return;
        }
        for (CustomRecipe rec : recipes) {
            Set<Object> researches;
            BuildingEntry craftingBuilding;
            if (!rec.getShowTooltip() || rec.getCrafter().length() < 2 || (craftingBuilding = (BuildingEntry)((Object)((Map)crafterToBuilding.get()).get(rec.getCrafter()))) == null) continue;
            ITextComponent craftingBuildingName = ClientEventHandler.getFullBuildingName(craftingBuilding);
            if (rec.getMinBuildingLevel() > 0) {
                String schematicName = craftingBuilding.getRegistryName().func_110623_a();
                TranslationTextComponent reqLevelText = new TranslationTextComponent("com.minecolonies.coremod.item.buildlevel.gui", new Object[]{craftingBuildingName, rec.getMinBuildingLevel()});
                if (colony != null && colony.hasBuilding(schematicName, rec.getMinBuildingLevel(), true)) {
                    reqLevelText.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA));
                } else {
                    reqLevelText.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED));
                }
                toolTip.add((ITextComponent)reqLevelText);
            } else {
                IFormattableTextComponent reqBuildingTxt = new TranslationTextComponent("com.minecolonies.coremod.item.available.gui", new Object[]{craftingBuildingName}).func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GRAY));
                toolTip.add((ITextComponent)reqBuildingTxt);
            }
            if (rec.getRequiredResearchId() == null) continue;
            if (IMinecoloniesAPI.getInstance().getGlobalResearchTree().hasResearch(rec.getRequiredResearchId())) {
                researches = new HashSet<IGlobalResearch>();
                researches.add(IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearch(rec.getRequiredResearchId()));
            } else {
                researches = IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearchForEffect(rec.getRequiredResearchId());
            }
            if (researches == null) continue;
            TextFormatting researchFormat = colony != null && (colony.getResearchManager().getResearchTree().hasCompletedResearch(rec.getRequiredResearchId()) || colony.getResearchManager().getResearchEffects().getEffectStrength(rec.getRequiredResearchId()) > 0.0) ? TextFormatting.AQUA : TextFormatting.RED;
            for (IGlobalResearch iGlobalResearch : researches) {
                toolTip.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.item.requiresresearch.gui", new Object[]{iGlobalResearch.getName()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(researchFormat)));
            }
        }
    }

    private static ITextComponent getFullBuildingName(@NotNull BuildingEntry building) {
        String namespace = building.getBuildingBlock().getRegistryName().func_110624_b();
        String modName = ModList.get().getModContainerById(namespace).map(m -> m.getModInfo().getDisplayName()).orElse(namespace);
        IFormattableTextComponent buildingName = building.getBuildingBlock().func_235333_g_();
        return new StringTextComponent(modName + " ").func_230529_a_((ITextComponent)buildingName);
    }

    private static Map<String, BuildingEntry> buildCrafterToBuildingMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            building.getModuleProducers().stream().map(Supplier::get).filter(m -> m instanceof ICraftingBuildingModule).map(m -> (ICraftingBuildingModule)m).filter(m -> m.getCraftingJob() != null).forEach(crafting -> builder.put((Object)crafting.getCustomRecipeKey(), (Object)building));
        }
        return builder.build();
    }

    private static void handleHutBlockResearchUnlocks(IColony colony, List<ITextComponent> tooltip, Block block) {
        if (colony == null) {
            return;
        }
        ResourceLocation effectId = colony.getResearchManager().getResearchEffectIdFrom(block.getBlock());
        if (colony.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0) {
            return;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearchForEffect(effectId) != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.item1", new Object[]{block.getBlock().func_235333_g_()}));
            tooltip.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.item2", new Object[]{block.getBlock().func_235333_g_()}));
        }
    }

    private static void handleRenderBuildTool(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        if (Settings.instance.getActiveStructure() == null) {
            return;
        }
        IColonyView colony = IColonyManager.getInstance().getClosestColonyView((World)world, new BlockPos(player.func_213303_ch()));
        if (colony == null) {
            return;
        }
        BlockPos activePosition = Settings.instance.getPosition();
        HashMap<BlockPos, Triple<Blueprint, BlockPos, BlockPos>> newCache = new HashMap<BlockPos, Triple<Blueprint, BlockPos, BlockPos>>();
        for (IBuildingView iBuildingView : colony.getBuildings()) {
            BlockPos currentPosition;
            if (!((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getClient().neighborbuildingrendering.get()).booleanValue() || iBuildingView.getBuildingType() == ModBuildings.postBox || iBuildingView.getBuildingType() == ModBuildings.stash || !activePosition.func_218141_a((Vector3i)(currentPosition = iBuildingView.getPosition()), 25.0)) continue;
            if (blueprintCache.containsKey(currentPosition)) {
                newCache.put(currentPosition, blueprintCache.get(currentPosition));
                continue;
            }
            TileEntity tile = world.func_175625_s(iBuildingView.getID());
            String schematicName = iBuildingView.getSchematicName();
            if (tile instanceof IBlueprintDataProvider && !((IBlueprintDataProvider)tile).getSchematicName().isEmpty()) {
                schematicName = ((IBlueprintDataProvider)tile).getSchematicName().replaceAll("\\d$", "");
            }
            StructureName sn = new StructureName("schematics", iBuildingView.getStyle(), schematicName + iBuildingView.getBuildingMaxLevel());
            String structureName = sn.toString();
            String md5 = Structures.getMD5((String)structureName);
            LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler((World)world, iBuildingView.getID(), structureName, new PlacementSettings(), true);
            if (!wrapper.hasBluePrint() || !wrapper.isCorrectMD5(md5)) {
                if (alreadyRequestedStructures.contains(structureName)) continue;
                alreadyRequestedStructures.add(structureName);
                Log.getLogger().error("Couldn't find schematic: " + structureName + " requesting to server if possible.");
                if (ServerLifecycleHooks.getCurrentServer() != null) continue;
                Network.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(structureName));
                continue;
            }
            Blueprint blueprint = wrapper.getBluePrint();
            Mirror mirror = iBuildingView.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE;
            blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(iBuildingView.getRotation()), mirror, (World)world);
            BlockPos primaryOffset = blueprint.getPrimaryBlockOffset();
            BlockPos boxStartPos = currentPosition.func_177973_b((Vector3i)primaryOffset);
            BlockPos size = new BlockPos((int)blueprint.getSizeX(), (int)blueprint.getSizeY(), (int)blueprint.getSizeZ());
            BlockPos boxEndPos = boxStartPos.func_177971_a((Vector3i)size).func_177973_b((Vector3i)new BlockPos(1, 1, 1));
            blueprint.setRenderSource(iBuildingView.getID());
            if (iBuildingView.getBuildingLevel() < iBuildingView.getBuildingMaxLevel()) {
                newCache.put(currentPosition, (Triple<Blueprint, BlockPos, BlockPos>)new Triple((Object)blueprint, (Object)boxStartPos, (Object)boxEndPos));
                continue;
            }
            newCache.put(currentPosition, (Triple<Blueprint, BlockPos, BlockPos>)new Triple(null, (Object)boxStartPos, (Object)boxEndPos));
        }
        blueprintCache = newCache;
        for (Map.Entry entry : blueprintCache.entrySet()) {
            Triple buildingData = (Triple)entry.getValue();
            BlockPos position = (BlockPos)entry.getKey();
            if (buildingData.a != null) {
                StructureClientHandler.renderStructureAtPos((Blueprint)((Blueprint)buildingData.a), (float)event.getPartialTicks(), (BlockPos)position, (MatrixStack)event.getMatrixStack());
            }
            RenderUtils.renderBox((BlockPos)((BlockPos)buildingData.b), (BlockPos)((BlockPos)buildingData.c), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (double)0.002, (MatrixStack)event.getMatrixStack(), (IVertexBuilder)linesWithCullAndDepth.get());
        }
    }

    private static void handleRenderStructure(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        IColonyView tempView;
        PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
        if (Settings.instance.getStructureName() != null && Settings.instance.getStructureName().contains("infrastructure") && (tempView = IColonyManager.getInstance().getClosestColonyView((World)world, new BlockPos(player.func_213303_ch()))) != null) {
            if (wayPointTemplate == null) {
                wayPointTemplate = new LoadOnlyStructureHandler((World)world, BlockPos.field_177992_a, "schematics/infrastructure/waypoint", settings, true).getBluePrint();
            }
            StructureClientHandler.renderStructureAtPosList((Blueprint)(Settings.instance.getActiveStructure().hashCode() == wayPointTemplate.hashCode() ? Settings.instance.getActiveStructure() : wayPointTemplate), (float)event.getPartialTicks(), new ArrayList<BlockPos>(tempView.getWayPoints().keySet()), (MatrixStack)event.getMatrixStack());
        }
    }

    private static void handleRenderScepterGuard(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT compound = stack.func_77978_p();
        IColonyView colony = IColonyManager.getInstance().getColonyView(compound.func_74762_e("id"), (RegistryKey<World>)player.field_70170_p.func_234923_W_());
        if (colony == null) {
            return;
        }
        BlockPos guardTower = BlockPosUtil.read(compound, "pos");
        IBuildingView hut = colony.getBuilding(guardTower);
        if (hut == null) {
            return;
        }
        if (partolPointTemplate == null) {
            partolPointTemplate = new LoadOnlyStructureHandler((World)world, hut.getPosition(), "schematics/infrastructure/patrolpoint", settings, true).getBluePrint();
        }
        if (hut instanceof AbstractBuildingGuards.View) {
            StructureClientHandler.renderStructureAtPosList((Blueprint)partolPointTemplate, (float)event.getPartialTicks(), ((AbstractBuildingGuards.View)hut).getPatrolTargets().stream().map(BlockPos::func_177984_a).collect(Collectors.toList()), (MatrixStack)event.getMatrixStack());
        }
    }

    private static void handleRenderBannerRallyGuards(@NotNull RenderWorldLastEvent event, ClientWorld world, PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        ImmutableList<ILocation> guardTowers = ItemBannerRallyGuards.getGuardTowerLocations(stack);
        for (ILocation guardTower : guardTowers) {
            if (world.func_234923_W_() == guardTower.getDimension()) continue;
            RenderUtils.renderBox((BlockPos)guardTower.getInDimensionLocation(), (BlockPos)guardTower.getInDimensionLocation(), (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (double)0.002, (MatrixStack)event.getMatrixStack(), (IVertexBuilder)linesWithCullAndDepth.get());
        }
    }

    static {
        blueprintCache = new HashMap<BlockPos, Triple<Blueprint, BlockPos, BlockPos>>();
        renderBuffers = new RenderTypeBuffers();
        renderBuffer = renderBuffers.func_228487_b_();
        linesWithCullAndDepth = () -> renderBuffer.getBuffer(RenderType.func_228659_m_());
        linesWithoutCullAndDepth = () -> renderBuffer.getBuffer(RenderUtils.LINES_GLINT);
        crafterToBuilding = Lazy.of(ClientEventHandler::buildCrafterToBuildingMap);
        alreadyRequestedStructures = new HashSet<String>();
    }
}

