/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyRelated;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.sounds.MercenarySounds;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.EntityMercenaryAI;
import com.minecolonies.coremod.entity.pathfinding.GeneralEntityWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityMercenary
extends CreatureEntity
implements INPC,
IColonyRelated {
    private static final int SLAP_INTERVAL = 100;
    private IColony colony;
    private AbstractAdvancedPathNavigate newNavigator;
    private GeneralEntityWalkToProxy proxy;
    private int slapTimer = 0;
    private final Random rand = new Random();
    private long worldTimeAtSpawn = 0L;
    private boolean isLeader = false;
    private List<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
    private int spawnEventTime = 0;
    private boolean doSpawnEvent = false;
    private ITickRateStateMachine<IState> stateMachine;
    private static final String ENTITY_NAME = "Mercenary";

    public EntityMercenary(EntityType<EntityMercenary> type, World world) {
        super(type, world);
        this.field_70714_bg = new CustomGoalSelector(this.field_70714_bg);
        this.field_70715_bh = new CustomGoalSelector(this.field_70715_bh);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityMercenaryAI(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new EntityAIInteractToggleAble((MobEntity)this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, 10, true, false, e -> e instanceof IMob && !(e instanceof LlamaEntity)));
        this.field_98038_p = true;
        this.func_174805_g(true);
        this.func_110163_bv();
        ItemStack mainhand = new ItemStack((IItemProvider)Items.field_151010_B, 1);
        mainhand.func_77966_a(Enchantments.field_77334_n, 1);
        this.func_184201_a(EquipmentSlotType.MAINHAND, mainhand);
        ItemStack helmet = new ItemStack((IItemProvider)Items.field_151161_ac, 1);
        helmet.func_77966_a(Enchantments.field_180310_c, 4);
        this.func_184201_a(EquipmentSlotType.HEAD, helmet);
        ItemStack chest = new ItemStack((IItemProvider)Items.field_151171_ah, 1);
        chest.func_77966_a(Enchantments.field_180310_c, 4);
        this.func_184201_a(EquipmentSlotType.CHEST, chest);
        ItemStack legs = new ItemStack((IItemProvider)Items.field_151022_W, 1);
        this.func_184201_a(EquipmentSlotType.LEGS, legs);
        ItemStack boots = new ItemStack((IItemProvider)Items.field_151029_X, 1);
        this.func_184201_a(EquipmentSlotType.FEET, boots);
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a(35.0);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.3);
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(60.0);
        this.func_70606_j(this.func_110138_aP());
        this.stateMachine = new TickRateStateMachine<EntityMercenaryAI.State>(EntityMercenaryAI.State.INIT, this::handleStateException);
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.INIT, this::isInitialized, () -> EntityMercenaryAI.State.SPAWN_EVENT, 20));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.SPAWN_EVENT, this::spawnEvent, () -> EntityMercenaryAI.State.ALIVE, 30));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.ALIVE, this::shouldDespawn, () -> EntityMercenaryAI.State.DEAD, 100));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.DEAD, () -> true, this::getState, 500));
    }

    private void handleStateException(RuntimeException e) {
        Log.getLogger().warn("Mercenary entity threw an exception:", (Throwable)e);
    }

    private boolean shouldDespawn() {
        if (this.field_70170_p == null || this.field_70170_p.func_82737_E() - this.worldTimeAtSpawn > 48000L || this.colony == null || this.func_82150_aj()) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    private boolean isInitialized() {
        if (this.worldTimeAtSpawn == 0L) {
            this.worldTimeAtSpawn = this.field_70170_p.func_82737_E();
        }
        return this.field_70170_p != null && this.colony != null && this.func_70089_S() && !this.func_82150_aj();
    }

    private boolean spawnEvent() {
        if (this.spawnEventTime > 0) {
            --this.spawnEventTime;
        }
        if (!this.doSpawnEvent || this.spawnEventTime == 0) {
            return true;
        }
        if (!this.isLeader) {
            return false;
        }
        if (!this.getNavigation().func_75500_f()) {
            return false;
        }
        BlockPos first = this.soldiers.get(0).func_233580_cy_().func_177982_a(0, 0, 1);
        BlockPos last = this.soldiers.get(this.soldiers.size() - 1).func_233580_cy_().func_177982_a(0, 0, 1);
        this.func_184185_a(MercenarySounds.mercenaryCelebrate, 2.0f, 1.0f);
        if (this.func_233580_cy_().equals((Object)first)) {
            this.getNavigation().tryMoveToBlockPos(last, 0.5);
        } else {
            this.getNavigation().tryMoveToBlockPos(first, 0.5);
        }
        return false;
    }

    public BlockPos func_233580_cy_() {
        return new BlockPos(this.func_213303_ch());
    }

    public void setDoSpawnEvent() {
        this.doSpawnEvent = true;
        this.spawnEventTime = 15;
    }

    public void setLeader(List<EntityMercenary> soldiers) {
        this.soldiers = soldiers;
        this.isLeader = true;
        this.doSpawnEvent = true;
        this.spawnEventTime = 17;
    }

    public IState getState() {
        return this.stateMachine.getState();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(MercenarySounds.mercenaryStep, 0.45f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MercenarySounds.mercenaryHurt;
    }

    protected SoundEvent func_184615_bR() {
        return MercenarySounds.mercenaryDie;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return MercenarySounds.mercenarySay;
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74772_a("time", this.worldTimeAtSpawn);
        compound.func_74768_a("colony", this.colony == null ? 0 : this.colony.getID());
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.func_74763_f("time");
        if (compound.func_150296_c().contains("colony") && (colonyId = compound.func_74762_e("colony")) != 0) {
            this.setColony(IColonyManager.getInstance().getColonyByWorld(colonyId, this.field_70170_p));
        }
        super.func_70037_a(compound);
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent(ENTITY_NAME);
    }

    @Override
    public void registerWithColony() {
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233823_f_, Attributes.field_233823_f_.func_111110_b()).func_233815_a_(Attributes.field_233819_b_, 100.0);
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
            this.registerWithColony();
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof LivingEntity) {
            this.func_70624_b((LivingEntity)source.func_76346_g());
        }
        return super.func_70097_a(source, damage);
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.slapTimer == 0 && entityIn instanceof PlayerEntity) {
            this.slapTimer = 100;
            entityIn.func_70097_a((DamageSource)new EntityDamageSource("slap", (Entity)this), 1.0f);
            this.func_184609_a(Hand.OFF_HAND);
        }
        if (this.slapTimer == 0 && entityIn instanceof EntityCitizen && this.colony != null && ((EntityCitizen)entityIn).isActive()) {
            this.slapTimer = 100;
            IItemHandler handler = ((EntityCitizen)entityIn).getItemHandlerCitizen();
            ItemStack stack = handler.extractItem(this.rand.nextInt(handler.getSlots()), 5, false);
            if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                this.func_184609_a(Hand.OFF_HAND);
                MessageUtils.format("com.minecolonies.coremod.mercenary.mercenarystealcitizen", entityIn.func_200200_C_().getString(), stack.func_200301_q().getString()).sendTo(this.colony).forAllPlayers();
            }
        }
    }

    public GeneralEntityWalkToProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new GeneralEntityWalkToProxy((MobEntity)this);
        }
        return this.proxy;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = new MinecoloniesAdvancedPathNavigate((MobEntity)this, this.field_70170_p);
            this.field_70699_by = this.newNavigator;
            this.newNavigator.func_212239_d(true);
            this.newNavigator.func_189566_q().func_186321_b(true);
        }
        return this.newNavigator;
    }

    public void func_70636_d() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.stateMachine.tick();
        }
        if (this.slapTimer > 0) {
            --this.slapTimer;
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    public boolean func_213392_I() {
        return true;
    }

    public static void spawnMercenariesInColony(@NotNull IColony colony) {
        World world = colony.getWorld();
        if (colony.getMercenaryUseTime() != 0L && world.func_82737_E() - colony.getMercenaryUseTime() < 48000L) {
            return;
        }
        colony.usedMercenaries();
        int amountOfMercenaries = colony.getCitizenManager().getCurrentCitizenCount();
        amountOfMercenaries /= 10;
        BlockPos spawn = EntityMercenary.findMercenarySpawnPos(colony, amountOfMercenaries += 3);
        ArrayList<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
        for (int i = 0; i < amountOfMercenaries; ++i) {
            EntityMercenary merc = (EntityMercenary)ModEntities.MERCENARY.func_200721_a(world);
            merc.setColony(colony);
            merc.func_70107_b(spawn.func_177958_n() + i, spawn.func_177956_o(), spawn.func_177952_p());
            merc.setDoSpawnEvent();
            soldiers.add(merc);
            world.func_217376_c((Entity)merc);
        }
        EntityMercenary merc = (EntityMercenary)ModEntities.MERCENARY.func_200721_a(world);
        merc.setColony(colony);
        merc.func_70107_b(spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p() + 1);
        merc.setLeader(soldiers);
        world.func_217376_c((Entity)merc);
    }

    private static BlockPos findMercenarySpawnPos(IColony colony, int amountOfMercenaries) {
        Tuple<BlockPos, BlockPos> buildingArea = colony.getBuildingManager().getTownHall().getCorners();
        BlockPos spawn = new BlockPos((((BlockPos)buildingArea.func_76340_b()).func_177958_n() + ((BlockPos)buildingArea.func_76341_a()).func_177958_n()) / 2, 0, ((BlockPos)buildingArea.func_76341_a()).func_177952_p());
        double height = colony.getWorld().func_201676_a(Heightmap.Type.WORLD_SURFACE, spawn.func_177958_n(), spawn.func_177952_p());
        if (height > (double)((BlockPos)buildingArea.func_76340_b()).func_177956_o()) {
            height = ((BlockPos)buildingArea.func_76341_a()).func_177956_o() + 1;
        }
        spawn = spawn.func_177963_a(0.0, height, 0.0);
        for (int i = -3; i < 4; ++i) {
            if (!EntityMercenary.isValidSpawnForMercenaries((IWorld)colony.getWorld(), spawn.func_177982_a(0, 0, i), amountOfMercenaries)) continue;
            spawn = spawn.func_177982_a(0, 0, i);
            break;
        }
        return spawn;
    }

    private static boolean isValidSpawnForMercenaries(IWorld world, BlockPos spawn, int amountOfMercenaries) {
        for (int i = 0; i < amountOfMercenaries; ++i) {
            if (world.func_175623_d(spawn.func_177984_a().func_177982_a(i, 0, 0)) && world.func_175623_d(spawn.func_177984_a().func_177982_a(i, 0, 1))) continue;
            return false;
        }
        return true;
    }
}

