/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.SittingEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;

public class EntityAICitizenWander
extends Goal {
    private static final int LEISURE_CHANCE = 5;
    protected final AbstractEntityCitizen citizen;
    protected final double speed;
    private final TickRateStateMachine<WanderState> stateMachine;
    private BlockPos walkTo;
    private BlockPos leisureSite;

    public EntityAICitizenWander(AbstractEntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<WanderState>(WanderState.IDLE, e -> Log.getLogger().warn("Wandering AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.IDLE, () -> true, this::decide, 20));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.GO_TO_LEISURE_SITE, () -> true, this::goToLeisureSite, 20));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.WANDER_AT_LEISURE_SITE, () -> true, this::wanderAtLeisureSite, 20));
        this.stateMachine.addTransition(new TickingTransition<WanderState>(WanderState.READ_A_BOOK, () -> true, this::readABook, 20));
    }

    private WanderState readABook() {
        if (this.leisureSite == null) {
            this.walkTo = null;
            return WanderState.IDLE;
        }
        if (this.walkTo != null) {
            if (!this.citizen.isWorkerAtSiteWithMove(this.walkTo, 3)) {
                return WanderState.READ_A_BOOK;
            }
            if (this.citizen.func_70681_au().nextInt(100) < 5) {
                this.citizen.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                this.walkTo = null;
                this.leisureSite = null;
                this.citizen.getCitizenData().getCitizenSkillHandler().tryLevelUpIntelligence(this.citizen.func_70681_au(), 8.0, this.citizen.getCitizenData());
                return WanderState.IDLE;
            }
            this.citizen.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151122_aG));
            return WanderState.READ_A_BOOK;
        }
        TileEntity blockEntity = this.citizen.field_70170_p.func_175625_s(this.leisureSite);
        if (blockEntity instanceof TileEntityColonyBuilding && ((TileEntityColonyBuilding)blockEntity).getBuilding() instanceof BuildingLibrary) {
            this.walkTo = ((BuildingLibrary)((TileEntityColonyBuilding)blockEntity).getBuilding()).getRandomBookShelf();
        }
        return WanderState.READ_A_BOOK;
    }

    private WanderState goToLeisureSite() {
        if (this.leisureSite == null) {
            this.walkTo = null;
            return WanderState.IDLE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.leisureSite, 3)) {
            return WanderState.GO_TO_LEISURE_SITE;
        }
        return WanderState.WANDER_AT_LEISURE_SITE;
    }

    private WanderState wanderAtLeisureSite() {
        if (this.leisureSite == null || this.citizen.func_70681_au().nextInt(300) < 1) {
            this.leisureSite = null;
            this.walkTo = null;
            return WanderState.IDLE;
        }
        if (this.walkTo != null && !this.citizen.isWorkerAtSiteWithMove(this.walkTo, 3)) {
            return WanderState.WANDER_AT_LEISURE_SITE;
        }
        if (this.citizen.func_184218_aH()) {
            return WanderState.WANDER_AT_LEISURE_SITE;
        }
        TileEntity blockEntity = this.citizen.field_70170_p.func_175625_s(this.leisureSite);
        if (blockEntity instanceof IBlueprintDataProvider) {
            if (this.walkTo == null && this.citizen.func_70681_au().nextBoolean()) {
                this.citizen.getNavigation().moveToRandomPos(10, 0.6, (Tuple<BlockPos, BlockPos>)((IBlueprintDataProvider)blockEntity).getInWorldCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
            }
            if (this.walkTo == null && blockEntity instanceof TileEntityColonyBuilding && ((TileEntityColonyBuilding)blockEntity).getBuilding() instanceof BuildingLibrary && this.citizen.func_70681_au().nextInt(100) < 5) {
                return WanderState.READ_A_BOOK;
            }
            if (this.walkTo == null) {
                Map map = ((IBlueprintDataProvider)blockEntity).getWorldTagNamePosMap();
                ArrayList sittingPos = new ArrayList(map.getOrDefault("sit", Collections.emptySet()));
                if (!sittingPos.isEmpty()) {
                    this.walkTo = (BlockPos)sittingPos.get(this.citizen.func_70681_au().nextInt(sittingPos.size()));
                    return WanderState.WANDER_AT_LEISURE_SITE;
                }
            } else {
                SittingEntity.sitDown(this.walkTo, (MobEntity)this.citizen, 1200);
                this.walkTo = null;
            }
            return WanderState.WANDER_AT_LEISURE_SITE;
        }
        return WanderState.IDLE;
    }

    private WanderState decide() {
        int randomBit = this.citizen.func_70681_au().nextInt(100);
        if (randomBit < 5) {
            this.leisureSite = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getRandomLeisureSite();
            if (this.leisureSite != null) {
                return WanderState.GO_TO_LEISURE_SITE;
            }
        }
        this.citizen.getNavigation().moveToRandomPos(10.0, this.speed);
        return WanderState.IDLE;
    }

    public boolean func_75250_a() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        return this.citizen.getDesiredActivity() != DesiredActivity.SLEEP && this.citizen.getNavigation().func_75500_f() && !this.citizen.func_70631_g_() && !(this.citizen.getCitizenData().getJob() instanceof AbstractJobGuard);
    }

    public void func_75246_d() {
        this.stateMachine.tick();
    }

    public boolean func_75253_b() {
        return !this.citizen.getNavigation().func_75500_f() || this.stateMachine.getState() != WanderState.IDLE;
    }

    public void func_75251_c() {
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
    }

    public static enum WanderState implements IState
    {
        IDLE,
        GO_TO_LEISURE_SITE,
        WANDER_AT_LEISURE_SITE,
        READ_A_BOOK;

    }
}

