/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class NewBobberEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(NewBobberEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int XP_PER_CATCH = 2;
    private boolean inGround;
    private int ticksInGround;
    private EntityCitizen angler;
    private int tickRemove = 100;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    public Entity caughtEntity;
    private State currentState = State.FLYING;
    private int luck;
    private int lureSpeed;
    private int anglerId = -1;
    private boolean readyToCatch = false;
    private Vector3d onWaterPos;

    public NewBobberEntity(EntityType<?> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    public NewBobberEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(ModEntities.FISHHOOK, world);
    }

    public void setAngler(EntityCitizen citizen, int luck, int lureSpeed) {
        this.angler = citizen;
        float pitch = (float)(Math.random() * 40.0 - 10.0);
        float yaw = this.angler.field_70177_z;
        float cowYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        double xYaw = this.angler.func_226277_ct_() - (double)sinYaw * 0.3;
        double eyePos = this.angler.func_226280_cw_();
        double zYaw = this.angler.func_226281_cx_() - (double)cowYaw * 0.3;
        this.func_70012_b(xYaw, eyePos, zYaw, yaw, pitch);
        Vector3d vec = new Vector3d((double)(-sinYaw), (double)MathHelper.func_76131_a((float)(-(sinPitch / cosPitch)), (float)-5.0f, (float)5.0f), (double)(-cowYaw));
        double d3 = vec.func_72433_c();
        vec = vec.func_216372_d(0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045);
        this.func_213317_d(vec);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec.field_72450_a, (double)vec.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec.field_72448_b, (double)MathHelper.func_76133_a((double)NewBobberEntity.func_213296_b((Vector3d)vec))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    protected void func_70037_a(@NotNull CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d() && --this.tickRemove <= 0) {
            this.func_70106_y();
            return;
        }
        if (this.angler == null) {
            if (this.field_70170_p.field_72995_K) {
                if (this.anglerId > -1) {
                    this.angler = (EntityCitizen)this.field_70170_p.func_73045_a(this.anglerId);
                }
            } else {
                this.func_70106_y();
            }
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos(this.func_213303_ch());
            FluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                f = ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.func_213317_d(Vector3d.field_186680_a);
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (this.caughtEntity.field_70128_L) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.func_70107_b(this.caughtEntity.func_226277_ct_(), this.caughtEntity.func_226283_e_(0.8), this.caughtEntity.func_226281_cx_());
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vector3d Vector3d2 = this.func_213322_ci();
                    double d0 = this.func_226278_cu_() + Vector3d2.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(Vector3d2.field_72450_a * 0.9, Vector3d2.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, Vector3d2.field_72449_c * 0.9);
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.updateRotation();
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
            this.func_226264_Z_();
        }
    }

    public boolean shouldStopFishing() {
        ItemStack itemstack = this.angler.func_184614_ca();
        ItemStack itemstack1 = this.angler.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof FishingRodItem;
        boolean flag1 = itemstack1.func_77973_b() instanceof FishingRodItem;
        if (!this.angler.field_70128_L && this.angler.func_70089_S() && (flag || flag1) && !(this.func_70068_e((Entity)this.angler) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void updateRotation() {
        Vector3d Vector3d2 = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)NewBobberEntity.func_213296_b((Vector3d)Vector3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
    }

    private void checkCollision() {
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, entity -> !(entity.func_175149_v() || !entity.func_70067_L() && !(entity instanceof ItemEntity) || entity == this.angler && this.ticksInAir < 5));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.caughtEntity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos p_190621_1_) {
        ServerWorld serverworld = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_190621_1_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_226660_f_(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat(), 0.0));
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                double d1;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.func_226277_ct_() + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                if (serverworld.func_180495_p(new BlockPos((int)d0, (int)(d1 = (double)((float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f)) - 1, (int)(d2 = this.func_226281_cx_() + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)))).func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.readyToCatch = true;
                this.onWaterPos = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                Vector3d Vector3d2 = this.func_213322_ci();
                this.func_213293_j(Vector3d2.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), Vector3d2.field_72449_c);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_226278_cu_() + 0.5;
                serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                if (serverworld.func_180495_p(new BlockPos(d4, (d5 = (double)((float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f)) - 1.0, d6 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f))).func_185904_a() == Material.field_151586_h) {
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_218422_X, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1060, (int)1300);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
            this.ticksCaughtDelay = Math.max(5, this.ticksCaughtDelay);
        }
    }

    public int getDamage() {
        if (!this.field_70170_p.field_72995_K && this.angler != null) {
            int i = 0;
            Object event = null;
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.caughtEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)this.getAngler().func_184614_ca()).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216023_a(this.field_70146_Z).func_186469_a((float)this.luck);
                lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this.angler).func_216015_a(LootParameters.field_216281_a, (Object)this);
                LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(ModLootTables.FISHING);
                List list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.onWaterPos.field_72450_a, this.onWaterPos.field_72448_b, this.onWaterPos.field_72449_c, itemstack);
                    double d0 = this.angler.func_226277_ct_() - this.onWaterPos.field_72450_a;
                    double d1 = this.angler.func_226278_cu_() + 0.5 - this.onWaterPos.field_72448_b;
                    double d2 = this.angler.func_226281_cx_() - this.onWaterPos.field_72449_c;
                    itementity.field_70145_X = true;
                    itementity.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.field_70170_p.func_217376_c((Entity)itementity);
                    this.angler.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.angler.field_70170_p, this.angler.func_226277_ct_(), this.angler.func_226278_cu_() + 0.5, this.angler.func_226281_cx_() + 0.5, 2));
                }
                i = 1;
            }
            if (this.inGround) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.caughtEntity instanceof EntityCitizen) {
            this.bringInHookedEntity();
        }
        super.func_70103_a(id);
    }

    protected void bringInHookedEntity() {
        if (this.angler != null) {
            Vector3d Vector3d2 = new Vector3d(this.angler.func_226277_ct_() - this.func_226277_ct_(), this.angler.func_226278_cu_() - this.func_226278_cu_(), this.angler.func_226281_cx_() - this.func_226281_cx_()).func_186678_a(0.1);
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_178787_e(Vector3d2));
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Nullable
    public EntityCitizen getAngler() {
        return this.angler;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        if (this.angler != null) {
            buffer.writeInt(this.angler.func_145782_y());
        } else {
            buffer.writeInt(-1);
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int citizenId = additionalData.readInt();
        if (citizenId != -1) {
            this.anglerId = citizenId;
        }
    }

    public boolean isReadyToCatch() {
        return this.readyToCatch;
    }

    public void setInUse() {
        this.tickRemove = 100;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

