/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.journeymap;

import java.util.Optional;
import journeymap.client.api.option.BooleanOption;
import journeymap.client.api.option.EnumOption;
import journeymap.client.api.option.KeyedEnum;
import journeymap.client.api.option.Option;
import journeymap.client.api.option.OptionCategory;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class JourneymapOptions {
    private final Option<BorderStyle> borderFullscreenStyle;
    private final Option<BorderStyle> borderMinimapStyle;
    private final Option<Boolean> deathpoints;
    private final Option<Boolean> colonyname;
    private final Option<Boolean> colonistNameMinimap;
    private final Option<Boolean> colonistNameFullscreen;
    private final Option<Boolean> colonistTooltips;
    private final Option<Boolean> colonistTeam;
    private final Option<Boolean> guards;
    private final Option<Boolean> citizens;
    private final Option<Boolean> visitors;
    private final Option<RaiderColor> raiders;

    public JourneymapOptions() {
        String prefix = "com.minecolonies.coremod.journeymap.options.";
        OptionCategory category = new OptionCategory("minecolonies", "com.minecolonies.coremod.journeymap.options.category");
        this.borderFullscreenStyle = new EnumOption(category, "borderFullscreenStyle", "com.minecolonies.coremod.journeymap.options.borderfullscreenstyle", (KeyedEnum)BorderStyle.FILLED).setSortOrder(100);
        this.borderMinimapStyle = new EnumOption(category, "borderMinimapStyle", "com.minecolonies.coremod.journeymap.options.borderminimapstyle", (KeyedEnum)BorderStyle.FRAMED).setSortOrder(101);
        this.deathpoints = new BooleanOption(category, "deathpoints", "com.minecolonies.coremod.journeymap.options.deathpoints", Boolean.valueOf(true)).setSortOrder(150);
        this.colonyname = new BooleanOption(category, "colonyname", "com.minecolonies.coremod.journeymap.options.colonyname", Boolean.valueOf(true)).setSortOrder(180);
        this.colonistNameMinimap = new BooleanOption(category, "colonistNameMinimap", "com.minecolonies.coremod.journeymap.options.colonistnameminimap", Boolean.valueOf(true)).setSortOrder(201);
        this.colonistNameFullscreen = new BooleanOption(category, "colonistNameFullscreen", "com.minecolonies.coremod.journeymap.options.colonistnamefullscreen", Boolean.valueOf(true)).setSortOrder(200);
        this.colonistTooltips = new BooleanOption(category, "colonistTooltips", "com.minecolonies.coremod.journeymap.options.colonisttooltips", Boolean.valueOf(true)).setSortOrder(202);
        this.colonistTeam = new BooleanOption(category, "colonistTeam", "com.minecolonies.coremod.journeymap.options.colonistteam", Boolean.valueOf(true)).setSortOrder(203);
        this.guards = new BooleanOption(category, "guards", "com.minecolonies.coremod.journeymap.options.guards", Boolean.valueOf(true)).setSortOrder(300);
        this.citizens = new BooleanOption(category, "citizens", "com.minecolonies.coremod.journeymap.options.citizens", Boolean.valueOf(true)).setSortOrder(301);
        this.visitors = new BooleanOption(category, "visitors", "com.minecolonies.coremod.journeymap.options.visitors", Boolean.valueOf(true)).setSortOrder(302);
        this.raiders = new EnumOption(category, "raiders", "com.minecolonies.coremod.journeymap.options.raiders", (KeyedEnum)RaiderColor.HOSTILE).setSortOrder(303);
    }

    public static BorderStyle getBorderFullscreenStyle(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (BorderStyle)((Object)((Object)o.borderFullscreenStyle.get()))).orElse(BorderStyle.FILLED);
    }

    public static BorderStyle getBorderMinimapStyle(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (BorderStyle)((Object)((Object)o.borderMinimapStyle.get()))).orElse(BorderStyle.FRAMED);
    }

    public static boolean getDeathpoints(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.deathpoints.get()).orElse(true);
    }

    public static boolean getShowColonyName(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.colonyname.get()).orElse(true);
    }

    public static boolean getShowColonistNameMinimap(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.colonistNameMinimap.get()).orElse(true);
    }

    public static boolean getShowColonistNameFullscreen(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.colonistNameFullscreen.get()).orElse(true);
    }

    public static boolean getShowColonistTooltip(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.colonistTooltips.get()).orElse(true);
    }

    public static boolean getShowColonistTeamColour(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.colonistTeam.get()).orElse(true);
    }

    public static boolean getShowGuards(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.guards.get()).orElse(true);
    }

    public static boolean getShowCitizens(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.citizens.get()).orElse(true);
    }

    public static boolean getShowVisitors(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (Boolean)o.visitors.get()).orElse(true);
    }

    public static RaiderColor getRaiderColor(@NotNull Optional<JourneymapOptions> options) {
        return options.map(o -> (RaiderColor)((Object)((Object)o.raiders.get()))).orElse(RaiderColor.HOSTILE);
    }

    public static enum RaiderColor implements KeyedEnum
    {
        HOSTILE("com.minecolonies.coremod.journeymap.raidercolor.hostile", Color.func_240743_a_((int)-1)),
        NONE("com.minecolonies.coremod.journeymap.raidercolor.none", Color.func_240743_a_((int)-16777216)),
        YELLOW("com.minecolonies.coremod.journeymap.raidercolor.yellow", Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW)),
        RED("com.minecolonies.coremod.journeymap.raidercolor.red", Color.func_240744_a_((TextFormatting)TextFormatting.RED)),
        PURPLE("com.minecolonies.coremod.journeymap.raidercolor.purple", Color.func_240744_a_((TextFormatting)TextFormatting.LIGHT_PURPLE)),
        ORANGE("com.minecolonies.coremod.journeymap.raidercolor.orange", Color.func_240744_a_((TextFormatting)TextFormatting.GOLD));

        private final String key;
        private final Color color;

        private RaiderColor(String key, Color color) {
            this.key = key;
            this.color = color;
        }

        public String getKey() {
            return this.key;
        }

        @NotNull
        public Color getColor() {
            return this.color;
        }
    }

    public static enum BorderStyle implements KeyedEnum
    {
        HIDDEN("com.minecolonies.coremod.journeymap.borderstyle.hidden"),
        FRAMED("com.minecolonies.coremod.journeymap.borderstyle.framed"),
        FILLED("com.minecolonies.coremod.journeymap.borderstyle.filled");

        private final String key;

        private BorderStyle(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

