/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class JobBasedRecipeCategory<T>
implements IRecipeCategory<T> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/gui/jei_recipe.png");
    @NotNull
    protected final IJob<?> job;
    @NotNull
    private final ResourceLocation uid;
    @NotNull
    private final ItemStack catalyst;
    @NotNull
    private final IDrawableStatic background;
    @NotNull
    private final IDrawable icon;
    @NotNull
    protected final IDrawableStatic slot;
    @NotNull
    protected final IDrawableStatic chanceSlot;
    @NotNull
    private final EntityCitizen citizen;
    @NotNull
    private final List<ITextProperties> description;
    @NotNull
    private final LoadingCache<T, List<InfoBlock>> infoBlocksCache;
    protected static final int WIDTH = 167;
    protected static final int HEIGHT = 120;
    protected static final int CITIZEN_X = 2;
    protected static final int CITIZEN_Y = 46;
    protected static final int CITIZEN_W = 47;
    protected static final int CITIZEN_H = 71;

    protected JobBasedRecipeCategory(@NotNull IJob<?> job, @NotNull ResourceLocation uid, @NotNull ItemStack icon, @NotNull IGuiHelper guiHelper) {
        this.job = job;
        this.uid = uid;
        this.catalyst = icon;
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 167, 120);
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        this.slot = guiHelper.getSlotDrawable();
        this.chanceSlot = guiHelper.createDrawable(TEXTURE, 0, 121, 18, 18);
        this.citizen = JobBasedRecipeCategory.createCitizenWithJob(this.job);
        this.description = JobBasedRecipeCategory.wordWrap(JobBasedRecipeCategory.breakLines(JobBasedRecipeCategory.translateDescription("com.minecolonies.coremod.jei." + this.job.getJobRegistryEntry().getRegistryName().func_110623_a())));
        this.infoBlocksCache = CacheBuilder.newBuilder().maximumSize(6L).build(new CacheLoader<T, List<InfoBlock>>(){

            @NotNull
            public List<InfoBlock> load(@NotNull T key) {
                return JobBasedRecipeCategory.this.calculateInfoBlocks(key);
            }
        });
    }

    @NotNull
    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    @NotNull
    protected static ItemStack getCatalyst(@NotNull BuildingEntry building) {
        return new ItemStack(building.getBuildingBlock());
    }

    @NotNull
    public IJob<?> getJob() {
        return this.job;
    }

    @NotNull
    public ResourceLocation getUid() {
        return this.uid;
    }

    @NotNull
    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    @NotNull
    public ITextComponent getTitleAsTextComponent() {
        return new TranslationTextComponent(this.job.getJobRegistryEntry().getTranslationKey());
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public Collection<?> findRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla) {
        return Collections.emptyList();
    }

    public void draw(@NotNull T recipe, @NotNull MatrixStack matrixStack, double mouseX, double mouseY) {
        float scale = 29.583332f;
        int citizen_cx = 25;
        int citizen_cy = 81;
        int citizen_by = 117;
        int offsetY = 4;
        float headYaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 40.0f;
        float yaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 20.0f;
        float pitch = (float)Math.atan((77.0 - mouseY) / 40.0) * 20.0f;
        RenderHelper.scissor(matrixStack, 2, 46, 47, 71);
        RenderHelper.renderEntity(matrixStack, 25, 113, 29.583332061767578, headYaw, yaw, pitch, (LivingEntity)this.citizen);
        RenderHelper.stopScissor();
        int y = 0;
        Minecraft mc = Minecraft.func_71410_x();
        for (ITextProperties line : this.description) {
            boolean x = false;
            mc.field_71466_p.func_238422_b_(matrixStack, LanguageMap.func_74808_a().func_241870_a(line), 0.0f, (float)y, TextFormatting.BLACK.func_211163_e().intValue());
            mc.field_71466_p.getClass();
            y += 9 + 2;
        }
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            mc.field_71466_p.func_238405_a_(matrixStack, block.text, (float)block.bounds.func_199318_a(), (float)block.bounds.func_199319_b(), TextFormatting.YELLOW.func_211163_e().intValue());
        }
    }

    @NotNull
    public List<ITextComponent> getTooltipStrings(@NotNull T recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            if (block.tip == null || !block.bounds.func_199315_b((int)mouseX, (int)mouseY)) continue;
            tooltips.add((ITextComponent)new StringTextComponent(block.tip));
        }
        return tooltips;
    }

    @NotNull
    private List<InfoBlock> calculateInfoBlocks(@NotNull T recipe) {
        List<ITextComponent> lines = this.generateInfoBlocks(recipe);
        Minecraft mc = Minecraft.func_71410_x();
        ArrayList<InfoBlock> result = new ArrayList<InfoBlock>();
        int y = 46;
        for (ITextComponent line : lines) {
            String key;
            String text = line.getString();
            int width = (int)mc.field_71466_p.func_238420_b_().func_238350_a_(text);
            mc.field_71466_p.getClass();
            int height = 9;
            int x = 167 - width;
            String tip = null;
            if (line instanceof TranslationTextComponent && I18n.func_188566_a((String)(key = ((TranslationTextComponent)line).func_150268_i() + ".tip"))) {
                tip = new TranslationTextComponent(key, ((TranslationTextComponent)line).func_150271_j()).getString();
            }
            result.add(new InfoBlock(text, tip, new Rectangle2d(x, y, width, height)));
            y += height + 2;
        }
        return result;
    }

    @NotNull
    protected abstract List<ITextComponent> generateInfoBlocks(@NotNull T var1);

    @NotNull
    private static EntityCitizen createCitizenWithJob(@NotNull IJob<?> job) {
        EntityCitizen citizen = new EntityCitizen(ModEntities.CITIZEN, (World)Minecraft.func_71410_x().field_71441_e);
        citizen.setFemale(citizen.func_70681_au().nextBoolean());
        citizen.setTextureId(citizen.func_70681_au().nextInt(255));
        citizen.func_184212_Q().func_187227_b(EntityCitizen.DATA_TEXTURE_SUFFIX, (Object)CitizenData.SUFFIXES.get(citizen.func_70681_au().nextInt(CitizenData.SUFFIXES.size())));
        citizen.setModelId(job.getModel());
        return citizen;
    }

    @NotNull
    private static List<ITextProperties> translateDescription(String ... keys) {
        return Arrays.stream(keys).map(TranslationTextComponent::new).collect(Collectors.toList());
    }

    @NotNull
    private static List<ITextProperties> breakLines(@NotNull List<ITextProperties> input) {
        ArrayList<ITextProperties> lines = new ArrayList<ITextProperties>();
        for (ITextProperties component : input) {
            Optional expanded = component.func_230438_a_(line -> Optional.of(line.split("\\\\n")));
            expanded.ifPresent(e -> lines.addAll(Arrays.stream(e).map(StringTextComponent::new).collect(Collectors.toList())));
        }
        return lines;
    }

    @NotNull
    private static List<ITextProperties> wordWrap(@NotNull List<ITextProperties> input) {
        Minecraft mc = Minecraft.func_71410_x();
        ArrayList<ITextProperties> lines = new ArrayList<ITextProperties>();
        for (ITextProperties component : input) {
            lines.addAll(mc.field_71466_p.func_238420_b_().func_238362_b_(component, 167, Style.field_240709_b_));
        }
        return lines;
    }

    protected static class LootTableTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private final int firstSlot;
        private final List<LootTableAnalyzer.LootDrop> drops;
        private final ResourceLocation id;

        public LootTableTooltipCallback(int firstSlot, List<LootTableAnalyzer.LootDrop> drops, ResourceLocation id) {
            this.firstSlot = firstSlot;
            this.drops = drops;
            this.id = id;
        }

        public void onTooltip(int slot, boolean input, @NotNull ItemStack stack, @NotNull List<ITextComponent> tooltip) {
            int index = slot - this.firstSlot;
            if (index >= 0 && index < this.drops.size()) {
                boolean showAdvanced;
                LootTableAnalyzer.LootDrop drop = this.drops.get(index);
                String key = "com.minecolonies.coremod.jei." + (drop.getQuality() < 0.0f ? "chancenegskill.tip" : (drop.getQuality() > 0.0f ? "chanceskill.tip" : "chance.tip"));
                float probability = drop.getProbability() * 100.0f;
                if (probability >= 1.0f) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(key, new Object[]{Math.round(probability)}));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent(key, new Object[]{Float.valueOf((float)Math.round(probability * 100.0f) / 100.0f)}));
                }
                if (drop.getConditional()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.jei.conditions.tip"));
                }
                boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_();
                if (showAdvanced) {
                    TranslationTextComponent recipeId = new TranslationTextComponent("com.minecolonies.coremod.jei.loottableid", new Object[]{this.id.toString()});
                    tooltip.add((ITextComponent)recipeId.func_240699_a_(TextFormatting.DARK_GRAY));
                }
            }
        }
    }

    protected static class RecipeIdTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private final int slot;
        private final ResourceLocation id;
        private final IModIdHelper modIdHelper;

        public RecipeIdTooltipCallback(int slot, ResourceLocation id, IModIdHelper modIdHelper) {
            this.slot = slot;
            this.id = id;
            this.modIdHelper = modIdHelper;
        }

        public void onTooltip(int slotIndex, boolean input, @NotNull ItemStack ingredient, @NotNull List<ITextComponent> tooltip) {
            boolean showAdvanced;
            String ingredientModId;
            String recipeModId;
            if (slotIndex != this.slot) {
                return;
            }
            if (this.modIdHelper.isDisplayingModNameEnabled() && !(recipeModId = this.id.func_110624_b()).equals(ingredientModId = ingredient.func_77973_b().getRegistryName().func_110624_b())) {
                String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
                TranslationTextComponent recipeBy = new TranslationTextComponent("jei.tooltip.recipe.by", new Object[]{modName});
                tooltip.add((ITextComponent)recipeBy.func_240699_a_(TextFormatting.GRAY));
            }
            boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_();
            if (showAdvanced) {
                TranslationTextComponent recipeId = new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{this.id.toString()});
                tooltip.add((ITextComponent)recipeId.func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }

    private static class InfoBlock {
        public final String text;
        public final String tip;
        public final Rectangle2d bounds;

        public InfoBlock(String text, String tip, Rectangle2d bounds) {
            this.text = text;
            this.tip = tip;
            this.bounds = bounds;
        }
    }
}

