/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandRaidAll
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        return this.raidsExecute(context, "");
    }

    public int onSpecificExecute(CommandContext<CommandSource> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.raidsExecute(context, StringArgumentType.getString(context, (String)"raidtype"));
    }

    public int raidsExecute(CommandContext<CommandSource> context, String raidType) {
        if (StringArgumentType.getString(context, (String)"raidtime").equals("now")) {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getRaiderManager().raiderEvent(raidType);
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.raidtonight"), true);
            return 1;
        }
        if (StringArgumentType.getString(context, (String)"raidtime").equals("tonight")) {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getRaiderManager().setRaidNextNight(true, raidType);
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.raidtonight"), true);
            return 1;
        }
        return 0;
    }

    @Override
    public String getName() {
        return "raid-All";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry type : IMinecoloniesAPI.getInstance().getColonyEventRegistry().getValues()) {
            if (type.getRegistryName().func_110623_a().equals(PirateGroundRaidEvent.PIRATE_GROUND_RAID_EVENT_TYPE_ID.func_110623_a()) || type.getRegistryName().func_110623_a().equals(NorsemenShipRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.func_110623_a())) continue;
            raidTypes.add(type.getRegistryName().func_110623_a());
        }
        String[] opt = new String[]{"now", "tonight"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197008_a((String[])opt, (SuggestionsBuilder)builder)).then(IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b((Iterable)raidTypes, (SuggestionsBuilder)builder)).executes(this::onSpecificExecute))).executes(this::checkPreConditionAndExecute));
    }
}

