/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.util.TeleportHelper;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

public class CommandTeleport
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        if (!IMCCommand.isPlayerOped((PlayerEntity)sender) && !((Boolean)MineColonies.getConfig().getServer().canPlayerUseColonyTPCommand.get()).booleanValue()) {
            MessageUtils.format("com.minecolonies.command.notenabledinconfig", new Object[0]).sendTo((PlayerEntity)sender);
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)((CommandSource)context.getSource()).func_197023_e().func_234923_W_());
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.colonyidnotfound", colonyID).sendTo((PlayerEntity)sender);
            return 0;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)sender;
        TeleportHelper.colonyTeleport(player, colony);
        return 1;
    }

    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

