/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CommandRaid
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        return this.raidExecute(context, "");
    }

    public int onSpecificExecute(CommandContext<CommandSource> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.raidExecute(context, StringArgumentType.getString(context, (String)"raidtype"));
    }

    public int raidExecute(CommandContext<CommandSource> context, String raidType) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)((CommandSource)context.getSource()).func_197023_e().func_234923_W_());
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.colonyidnotfound", new Object[]{colonyID}), true);
            return 0;
        }
        if (StringArgumentType.getString(context, (String)"raidtime").equals("now")) {
            colony.getRaiderManager().raiderEvent(raidType);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.raidnow.success", new Object[]{colony.getName()}), true);
        } else if (StringArgumentType.getString(context, (String)"raidtime").equals("tonight")) {
            colony.getRaiderManager().setRaidNextNight(true, raidType);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.raidtonight.success", new Object[]{colony.getName()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raid";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry type : IMinecoloniesAPI.getInstance().getColonyEventRegistry().getValues()) {
            if (type.getRegistryName().func_110623_a().equals(PirateGroundRaidEvent.PIRATE_GROUND_RAID_EVENT_TYPE_ID.func_110623_a()) || type.getRegistryName().func_110623_a().equals(NorsemenShipRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.func_110623_a())) continue;
            raidTypes.add(type.getRegistryName().func_110623_a());
        }
        String[] opt = new String[]{"now", "tonight"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197008_a((String[])opt, (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b((Iterable)raidTypes, (SuggestionsBuilder)builder)).executes(this::onSpecificExecute))).executes(this::checkPreConditionAndExecute)));
    }
}

