/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;

public class CommandClaimChunks
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        if (!(sender instanceof PlayerEntity)) {
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        int range = IntegerArgumentType.getInteger(context, (String)"range");
        if (range > (Integer)MineColonies.getConfig().getServer().maxColonySize.get()) {
            MessageUtils.format("com.minecolonies.command.claim.toolarge", colonyID).sendTo((PlayerEntity)sender);
            return 0;
        }
        boolean add = BoolArgumentType.getBool(context, (String)"add");
        IChunkmanagerCapability chunkManager = sender.field_70170_p.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return 0;
        }
        if (chunkManager.getAllChunkStorages().size() > 5000) {
            MessageUtils.format("com.minecolonies.command.claim.maxchunks", new Object[0]).sendTo((PlayerEntity)sender);
            return 0;
        }
        ChunkDataHelper.staticClaimInRange(colonyID, add, new BlockPos(sender.func_213303_ch()), range, sender.field_70170_p, true);
        if (add) {
            MessageUtils.format("com.minecolonies.command.claim.success", new Object[0]).sendTo((PlayerEntity)sender);
        } else {
            MessageUtils.format("com.minecolonies.command.claim.unclaim", new Object[0]).sendTo((PlayerEntity)sender);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "claim";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("range", IntegerArgumentType.integer((int)0, (int)10)).then(IMCCommand.newArgument("add", BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute))));
    }
}

