/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.util.AdvancementUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuilding
extends AbstractWorkOrder {
    private static final String TAG_CUSTOM_NAME = "customName";
    private static final String TAG_CUSTOM_PARENT_NAME = "customParentName";
    private static final String TAG_PARENT_TRANSLATION_KEY = "parentTranslationKey";
    private static final double MAX_DISTANCE_SQ = 10000.0;
    private String customName;
    private String customParentName;
    private String parentTranslationKey;

    public static WorkOrderBuilding create(@NotNull WorkOrderType type, @NotNull IBuilding building) {
        int targetLevel = building.getBuildingLevel();
        switch (type) {
            case BUILD: {
                targetLevel = 1;
                break;
            }
            case UPGRADE: {
                ++targetLevel;
                break;
            }
            case REMOVE: {
                targetLevel = 0;
            }
        }
        int targetSchematicLevel = type == WorkOrderType.REMOVE ? building.getBuildingLevel() : targetLevel;
        TileEntity buildingTE = building.getColony().getWorld().func_175625_s(building.getID());
        String schematicName = buildingTE instanceof AbstractTileEntityColonyBuilding ? (!((AbstractTileEntityColonyBuilding)buildingTE).getSchematicName().isEmpty() ? ((AbstractTileEntityColonyBuilding)buildingTE).getSchematicName().replaceAll("\\d$", "") + targetSchematicLevel : building.getSchematicName() + targetSchematicLevel) : building.getSchematicName() + targetSchematicLevel;
        String structureName = new StructureName("schematics", building.getStyle(), schematicName).toString();
        WorkOrderBuilding wo = new WorkOrderBuilding(structureName, building.getBuildingType().getTranslationKey(), type, building.getID(), building.getRotation(), building.getTileEntity() == null ? building.isMirrored() : building.getTileEntity().isMirrored(), building.getBuildingLevel(), targetLevel);
        wo.setCustomName(building);
        return wo;
    }

    public WorkOrderBuilding() {
    }

    private WorkOrderBuilding(String structureName, String workOrderName, WorkOrderType workOrderType, BlockPos location, int rotation, boolean isMirrored, int currentLevel, int targetLevel) {
        super(structureName, workOrderName, workOrderType, location, rotation, isMirrored, currentLevel, targetLevel);
    }

    public String getCustomName() {
        return this.customName;
    }

    public String getCustomParentName() {
        return this.customParentName;
    }

    public String getParentTranslationKey() {
        return this.parentTranslationKey;
    }

    public void setCustomName(@NotNull IBuilding building) {
        IBuilding parentBuilding;
        this.customName = building.getCustomName();
        this.customParentName = "";
        this.parentTranslationKey = "";
        if (building.hasParent() && (parentBuilding = building.getColony().getBuildingManager().getBuilding(building.getParent())) != null) {
            this.customParentName = parentBuilding.getCustomName();
            this.parentTranslationKey = parentBuilding.getBuildingType().getTranslationKey();
        }
    }

    @Override
    public ITextComponent getDisplayName() {
        TranslationTextComponent buildingComponent;
        String customParentName = this.getCustomParentName();
        String customName = this.getCustomName();
        Object object = buildingComponent = customName.isEmpty() ? new TranslationTextComponent(this.getWorkOrderName()) : new StringTextComponent(customName);
        if (this.parentTranslationKey.isEmpty()) {
            return buildingComponent;
        }
        TranslationTextComponent parentComponent = customParentName.isEmpty() ? new TranslationTextComponent(this.parentTranslationKey) : new StringTextComponent(customParentName);
        return new TranslationTextComponent("%s / %s", new Object[]{parentComponent, buildingComponent});
    }

    @Override
    public boolean canBeMadeBy(IJob<?> job) {
        return job instanceof JobBuilder;
    }

    @Override
    public boolean canBuild(@NotNull ICitizenData citizen) {
        IBuilding building = citizen.getWorkBuilding();
        return this.canBuildIgnoringDistance(building.getPosition(), building.getBuildingLevel()) && citizen.getWorkBuilding().getPosition().func_177951_i((Vector3i)this.getLocation()) <= 10000.0;
    }

    private boolean canBuildIgnoringDistance(@NotNull BlockPos builderLocation, int builderLevel) {
        return builderLevel >= this.getTargetLevel() || builderLevel == 5 || builderLocation.equals((Object)this.getLocation());
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().noneMatch(building -> building instanceof BuildingBuilder && !building.getAllAssignedCitizen().isEmpty() && building.getPosition().func_177951_i((Vector3i)this.getLocation()) <= 10000.0);
    }

    @Override
    public boolean isValid(@NotNull IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.getLocation()) != null;
    }

    @Override
    public void read(@NotNull CompoundNBT compound, IWorkManager manager) {
        super.read(compound, manager);
        this.customName = compound.func_74779_i(TAG_CUSTOM_NAME);
        this.customParentName = compound.func_74779_i(TAG_CUSTOM_PARENT_NAME);
        this.parentTranslationKey = compound.func_74779_i(TAG_PARENT_TRANSLATION_KEY);
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        super.write(compound);
        compound.func_74778_a(TAG_CUSTOM_NAME, this.customName);
        compound.func_74778_a(TAG_CUSTOM_PARENT_NAME, this.customParentName);
        compound.func_74778_a(TAG_PARENT_TRANSLATION_KEY, this.parentTranslationKey);
    }

    @Override
    public void serializeViewNetworkData(@NotNull PacketBuffer buf) {
        super.serializeViewNetworkData(buf);
        buf.func_180714_a(this.customName);
        buf.func_180714_a(this.customParentName);
        buf.func_180714_a(this.parentTranslationKey);
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
        super.onCompleted(colony, citizen);
        StructureName structureName = new StructureName(this.getStructureName());
        if (this.getWorkOrderType() != WorkOrderType.REMOVE) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, player -> AdvancementTriggers.COMPLETE_BUILD_REQUEST.trigger((ServerPlayerEntity)player, structureName, this.getTargetLevel()));
        }
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        IBuilding building;
        if (!readingFromNbt && colony != null && colony.getWorld() != null && (building = colony.getBuildingManager().getBuilding(this.getLocation())) != null) {
            ConstructionTapeHelper.placeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        IBuilding building = colony.getBuildingManager().getBuilding(this.getLocation());
        if (building != null) {
            building.markDirty();
            ConstructionTapeHelper.removeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }
}

