/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.workorders.WorkManager;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderMiner;
import com.minecolonies.coremod.colony.workorders.view.AbstractWorkOrderView;
import com.minecolonies.coremod.colony.workorders.view.WorkOrderBuildingView;
import com.minecolonies.coremod.colony.workorders.view.WorkOrderDecorationView;
import com.minecolonies.coremod.colony.workorders.view.WorkOrderMinerView;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkOrder
implements IWorkOrder {
    private static final String TAG_TYPE = "type";
    private static final String TAG_ID = "id";
    private static final String TAG_TH_PRIORITY = "priority";
    private static final String TAG_CLAIMED_BY = "claimedBy";
    private static final String TAG_CLAIMED_BY_BUILDING = "claimedByBuilding";
    private static final String TAG_STRUCTURE_NAME = "structureName";
    private static final String TAG_WO_NAME = "workOrderName";
    private static final String TAG_WO_TYPE = "workOrderType";
    private static final String TAG_LOCATION = "location";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_IS_MIRRORED = "isMirrored";
    private static final String TAG_CURRENT_LEVEL = "currentLevel";
    private static final String TAG_TARGET_LEVEL = "targetLevel";
    private static final String TAG_AMOUNT_OF_RESOURCES = "amountOfResources";
    private static final String TAG_ITERATOR = "iterator";
    private static final String TAG_IS_CLEARED = "cleared";
    private static final String TAG_IS_REQUESTED = "requested";
    private static final String TAG_BUILDING_OLD = "building";
    private static final String TAG_BUILDING_ROTATION_OLD = "buildingRotation";
    private static final String TAG_IS_MIRRORED_OLD = "mirrored";
    private static final String TAG_AMOUNT_OF_RESOURCES_OLD = "resQuantity";
    private static final String TAG_UPGRADE_LEVEL_OLD = "upgradeLevel";
    @NotNull
    private static final BiMap<String, Tuple<Class<? extends IWorkOrder>, Class<? extends IWorkOrderView>>> nameToClassBiMap = HashBiMap.create();
    private int id;
    private int priority;
    private BlockPos claimedBy;
    private String structureName;
    private String workOrderName;
    private WorkOrderType workOrderType;
    private BlockPos location;
    private int rotation;
    private boolean isMirrored;
    private int currentLevel;
    private int targetLevel;
    private int amountOfResources;
    private String iteratorType = "";
    private boolean cleared;
    private boolean requested;
    private boolean changed = false;

    private static void addMapping(String name, @NotNull Class<? extends IWorkOrder> orderClass, @NotNull Class<? extends IWorkOrderView> viewClass) {
        if (nameToClassBiMap.containsKey((Object)name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Work Order class mapping");
        }
        try {
            if (orderClass.getDeclaredConstructor(new Class[0]) != null) {
                nameToClassBiMap.put((Object)name, new Tuple<Class<? extends IWorkOrder>, Class<? extends IWorkOrderView>>(orderClass, viewClass));
                nameToClassBiMap.inverse().put(new Tuple<Class<? extends IWorkOrder>, Class<? extends IWorkOrderView>>(orderClass, viewClass), (Object)name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Work Order class mapping", exception);
        }
    }

    public static IWorkOrder createFromNBT(@NotNull CompoundNBT compound, WorkManager manager) {
        @Nullable IWorkOrder order = null;
        @Nullable Class oclass = null;
        try {
            String type = compound.func_74779_i(TAG_TYPE);
            oclass = type.equals("removal") ? WorkOrderBuilding.class : (Class)((Tuple)nameToClassBiMap.get((Object)type)).getA();
            if (oclass != null) {
                Constructor constructor = oclass.getDeclaredConstructor(new Class[0]);
                order = (IWorkOrder)constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (order == null) {
            Log.getLogger().warn(String.format("Unknown WorkOrder type '%s' or missing constructor of proper format.", compound.func_74779_i(TAG_TYPE)));
            return null;
        }
        try {
            order.read(compound, manager);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i(TAG_TYPE), oclass.getName()), (Throwable)ex);
            return null;
        }
        return order;
    }

    @Nullable
    public static IWorkOrderView createWorkOrderView(PacketBuffer buf) {
        @Nullable AbstractWorkOrderView orderView = null;
        String mappingName = buf.func_150789_c(Short.MAX_VALUE);
        try {
            @Nullable Class oclass = (Class)((Tuple)nameToClassBiMap.get((Object)mappingName)).getB();
            if (oclass != null) {
                Constructor constructor = oclass.getDeclaredConstructor(new Class[0]);
                orderView = (AbstractWorkOrderView)constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (orderView == null) {
            Log.getLogger().warn(String.format("Unknown WorkOrder type '%s' or missing constructor of proper format.", mappingName));
            return null;
        }
        try {
            orderView.deserialize(buf);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", orderView.getId()), (Throwable)ex);
            return null;
        }
        return orderView;
    }

    public AbstractWorkOrder() {
    }

    protected AbstractWorkOrder(String structureName, String workOrderName, WorkOrderType workOrderType, BlockPos location, int rotation, boolean isMirrored, int currentLevel, int targetLevel) {
        this();
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.workOrderType = workOrderType;
        this.location = location;
        this.rotation = rotation;
        this.isMirrored = isMirrored;
        this.currentLevel = currentLevel;
        this.targetLevel = targetLevel;
    }

    @Override
    public final int getID() {
        return this.id;
    }

    @Override
    public final void setID(int id) {
        this.id = id;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public final BlockPos getClaimedBy() {
        return this.claimedBy;
    }

    @Override
    public final void setClaimedBy(BlockPos claimedBy) {
        this.claimedBy = claimedBy;
    }

    @Override
    public final void setClaimedBy(@Nullable ICitizenData citizen) {
        this.changed = true;
        this.claimedBy = citizen != null && citizen.getWorkBuilding() != null ? citizen.getWorkBuilding().getPosition() : null;
    }

    @Override
    public final boolean isClaimed() {
        return this.claimedBy != null;
    }

    @Override
    public final boolean isClaimedBy(@NotNull ICitizenData citizen) {
        if (citizen.getWorkBuilding() != null) {
            return citizen.getWorkBuilding().getPosition().equals((Object)this.claimedBy);
        }
        return false;
    }

    @Override
    public final void clearClaimedBy() {
        this.changed = true;
        this.claimedBy = null;
    }

    @Override
    public final String getStructureName() {
        return this.structureName;
    }

    @Override
    public final String getWorkOrderName() {
        return this.workOrderName;
    }

    @Override
    public final WorkOrderType getWorkOrderType() {
        return this.workOrderType;
    }

    @Override
    public final BlockPos getLocation() {
        return this.location;
    }

    @Override
    public final int getRotation() {
        return this.rotation;
    }

    @Override
    public final boolean isMirrored() {
        return this.isMirrored;
    }

    @Override
    public final int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public final int getTargetLevel() {
        return this.targetLevel;
    }

    @Override
    public final int getAmountOfResources() {
        return this.amountOfResources;
    }

    @Override
    public final void setAmountOfResources(int newQuantity) {
        this.changed = true;
        this.amountOfResources = newQuantity;
    }

    @Override
    public final String getIteratorType() {
        return this.iteratorType;
    }

    @Override
    public final void setIteratorType(String iteratorType) {
        this.changed = true;
        this.iteratorType = iteratorType;
    }

    @Override
    public final boolean isCleared() {
        return this.cleared;
    }

    @Override
    public final void setCleared(boolean cleared) {
        this.changed = true;
        this.cleared = cleared;
    }

    @Override
    public final boolean isRequested() {
        return this.requested;
    }

    @Override
    public final void setRequested(boolean requested) {
        this.changed = true;
        this.requested = requested;
    }

    @Override
    public final boolean isDirty() {
        return this.changed;
    }

    @Override
    public final void resetChange() {
        this.changed = false;
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.workOrderName);
    }

    @Override
    public abstract boolean canBeMadeBy(IJob<?> var1);

    @Override
    public abstract boolean canBuild(@NotNull ICitizenData var1);

    @Override
    public boolean isValid(IColony colony) {
        return true;
    }

    @Override
    public void read(@NotNull CompoundNBT compound, IWorkManager manager) {
        AbstractWorkOrder.migrateOldNbt(compound, manager);
        this.id = compound.func_74762_e(TAG_ID);
        if (compound.func_74764_b(TAG_TH_PRIORITY)) {
            this.priority = compound.func_74762_e(TAG_TH_PRIORITY);
        }
        if (compound.func_74764_b(TAG_CLAIMED_BY)) {
            ICitizenData data;
            int citizenId = compound.func_74762_e(TAG_CLAIMED_BY);
            if (manager.getColony() != null && (data = manager.getColony().getCitizenManager().getCivilian(citizenId)) != null && data.getWorkBuilding() != null) {
                this.claimedBy = data.getWorkBuilding().getPosition();
            }
        } else if (compound.func_74764_b(TAG_CLAIMED_BY_BUILDING)) {
            this.claimedBy = BlockPosUtil.read(compound, TAG_CLAIMED_BY_BUILDING);
        }
        this.structureName = compound.func_74779_i(TAG_STRUCTURE_NAME);
        this.workOrderName = compound.func_74779_i(TAG_WO_NAME);
        this.workOrderType = WorkOrderType.values()[compound.func_74762_e(TAG_WO_TYPE)];
        this.location = BlockPosUtil.read(compound, TAG_LOCATION);
        this.rotation = compound.func_74762_e(TAG_ROTATION);
        this.isMirrored = compound.func_74767_n(TAG_IS_MIRRORED);
        this.currentLevel = compound.func_74762_e(TAG_CURRENT_LEVEL);
        this.targetLevel = compound.func_74762_e(TAG_TARGET_LEVEL);
        this.amountOfResources = compound.func_74762_e(TAG_AMOUNT_OF_RESOURCES);
        this.iteratorType = compound.func_74779_i(TAG_ITERATOR);
        this.cleared = compound.func_74767_n(TAG_IS_CLEARED);
        this.requested = compound.func_74767_n(TAG_IS_REQUESTED);
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        compound.func_74768_a(TAG_TH_PRIORITY, this.priority);
        compound.func_74778_a(TAG_TYPE, this.getMappingName());
        compound.func_74768_a(TAG_ID, this.id);
        if (this.claimedBy != null) {
            BlockPosUtil.write(compound, TAG_CLAIMED_BY_BUILDING, this.claimedBy);
        }
        compound.func_74778_a(TAG_STRUCTURE_NAME, this.structureName);
        compound.func_74778_a(TAG_WO_NAME, this.workOrderName);
        compound.func_74768_a(TAG_WO_TYPE, this.workOrderType.ordinal());
        BlockPosUtil.write(compound, TAG_LOCATION, this.location);
        compound.func_74768_a(TAG_ROTATION, this.rotation);
        compound.func_74757_a(TAG_IS_MIRRORED, this.isMirrored);
        compound.func_74768_a(TAG_CURRENT_LEVEL, this.currentLevel);
        compound.func_74768_a(TAG_TARGET_LEVEL, this.targetLevel);
        compound.func_74768_a(TAG_AMOUNT_OF_RESOURCES, this.amountOfResources);
        compound.func_74778_a(TAG_ITERATOR, this.iteratorType);
        compound.func_74757_a(TAG_IS_CLEARED, this.cleared);
        compound.func_74757_a(TAG_IS_REQUESTED, this.requested);
    }

    @Override
    public void serializeViewNetworkData(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.getMappingName());
        buf.writeInt(this.id);
        buf.writeInt(this.priority);
        buf.func_179255_a(this.claimedBy == null ? BlockPos.field_177992_a : this.claimedBy);
        buf.func_180714_a(this.structureName);
        buf.func_180714_a(this.workOrderName);
        buf.writeInt(this.workOrderType.ordinal());
        buf.func_179255_a(this.location);
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isMirrored);
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.targetLevel);
        buf.writeInt(this.amountOfResources);
        buf.func_180714_a(this.iteratorType);
        buf.writeBoolean(this.cleared);
        buf.writeBoolean(this.requested);
    }

    private String getMappingName() {
        Optional<String> s = nameToClassBiMap.entrySet().stream().filter(f -> this.getClass().equals(((Tuple)f.getValue()).getA())).map(Map.Entry::getKey).findFirst();
        if (!s.isPresent()) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        return s.get();
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
    }

    @Override
    public void onRemoved(IColony colony) {
    }

    @Override
    public boolean canBeResolved(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().anyMatch(building -> building instanceof BuildingBuilder && !building.getAllAssignedCitizen().isEmpty() && building.getBuildingLevel() >= level);
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return false;
    }

    private static void migrateOldNbt(CompoundNBT compound, IWorkManager manager) {
        IBuilding building;
        if (!compound.func_74764_b(TAG_BUILDING_OLD) && !compound.func_74779_i(TAG_TYPE).equals("removal")) {
            return;
        }
        BlockPosUtil.write(compound, TAG_LOCATION, BlockPosUtil.read(compound, TAG_BUILDING_OLD));
        compound.func_74768_a(TAG_ROTATION, compound.func_74762_e(TAG_BUILDING_ROTATION_OLD));
        compound.func_74757_a(TAG_ROTATION, compound.func_74767_n(TAG_BUILDING_ROTATION_OLD));
        compound.func_74768_a(TAG_AMOUNT_OF_RESOURCES, compound.func_74762_e(TAG_AMOUNT_OF_RESOURCES_OLD));
        int targetLevel = compound.func_74762_e(TAG_UPGRADE_LEVEL_OLD);
        if (compound.func_74779_i(TAG_TYPE).equals("removal")) {
            compound.func_74778_a(TAG_TYPE, TAG_BUILDING_OLD);
            compound.func_74768_a(TAG_WO_TYPE, WorkOrderType.REMOVE.ordinal());
            compound.func_74768_a(TAG_CURRENT_LEVEL, targetLevel);
            compound.func_74768_a(TAG_TARGET_LEVEL, 0);
        } else if (targetLevel == 1) {
            compound.func_74768_a(TAG_WO_TYPE, WorkOrderType.BUILD.ordinal());
            compound.func_74768_a(TAG_CURRENT_LEVEL, 0);
            compound.func_74768_a(TAG_TARGET_LEVEL, targetLevel);
        } else if (targetLevel > 1) {
            building = manager.getColony().getBuildingManager().getBuilding(BlockPosUtil.read(compound, TAG_LOCATION));
            TileEntity entity = manager.getColony().getWorld().func_175625_s(BlockPosUtil.read(compound, TAG_LOCATION));
            if (building != null) {
                if (building.getBuildingLevel() == targetLevel) {
                    compound.func_74768_a(TAG_WO_TYPE, WorkOrderType.REPAIR.ordinal());
                } else {
                    compound.func_74768_a(TAG_WO_TYPE, WorkOrderType.UPGRADE.ordinal());
                }
            } else if (entity instanceof TileEntityDecorationController) {
                TileEntityDecorationController dEntity = (TileEntityDecorationController)entity;
                if (dEntity.getTier() == targetLevel) {
                    compound.func_74768_a(TAG_WO_TYPE, WorkOrderType.REPAIR.ordinal());
                } else {
                    compound.func_74768_a(TAG_WO_TYPE, WorkOrderType.UPGRADE.ordinal());
                }
            }
            compound.func_74768_a(TAG_TARGET_LEVEL, targetLevel);
            compound.func_74768_a(TAG_CURRENT_LEVEL, building.getBuildingLevel());
        }
        compound.func_82580_o(TAG_BUILDING_OLD);
        compound.func_82580_o(TAG_BUILDING_ROTATION_OLD);
        compound.func_82580_o(TAG_IS_MIRRORED_OLD);
        compound.func_82580_o(TAG_AMOUNT_OF_RESOURCES_OLD);
        compound.func_82580_o(TAG_UPGRADE_LEVEL_OLD);
        building = manager.getColony().getBuildingManager().getBuilding(BlockPosUtil.read(compound, TAG_LOCATION));
        if (building != null) {
            WorkOrderBuilding test = new WorkOrderBuilding();
            test.setCustomName(building);
            compound.func_74778_a("customName", test.getCustomName());
            compound.func_74778_a("customParentName", test.getCustomParentName());
            compound.func_74778_a("parentTranslationKey", test.getParentTranslationKey());
        }
    }

    static {
        AbstractWorkOrder.addMapping(TAG_BUILDING_OLD, WorkOrderBuilding.class, WorkOrderBuildingView.class);
        AbstractWorkOrder.addMapping("decoration", WorkOrderDecoration.class, WorkOrderDecorationView.class);
        AbstractWorkOrder.addMapping("miner", WorkOrderMiner.class, WorkOrderMinerView.class);
    }
}

