/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseRequestResolver;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class WarehouseRequestResolverFactory
implements IRequestResolverFactory<WarehouseRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends WarehouseRequestResolver> getFactoryOutputType() {
        return TypeToken.of(WarehouseRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public WarehouseRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new WarehouseRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull WarehouseRequestResolver warehouseRequestResolver) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_TOKEN, (INBT)controller.serialize(warehouseRequestResolver.getId()));
        compound.func_218657_a(NBT_LOCATION, (INBT)controller.serialize(warehouseRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public WarehouseRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        return new WarehouseRequestResolver(location, token);
    }

    @Override
    public void serialize(IFactoryController controller, WarehouseRequestResolver input, PacketBuffer packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    public WarehouseRequestResolver deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        return new WarehouseRequestResolver(location, token);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.WAREHOUSE_REQUEST_RESOLVER_ID;
    }
}

