/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requests;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.IRequestFactory;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.Tag;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.colony.requestsystem.requests.StandardRequests;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public final class StandardRequestFactories {
    private static final String NBT_REQUESTER = "Requester";
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_STATE = "State";
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_PARENT = "Parent";
    private static final String NBT_CHILDREN = "Children";
    private static final String NBT_DELIVERIES = "Deliveries";

    private StandardRequestFactories() {
    }

    public static <T extends IRequestable> CompoundNBT serializeToNBT(IFactoryController controller, IRequest<T> request, IObjectToNBTConverter<T> typeSerialization) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT requesterCompound = controller.serialize(request.getRequester());
        CompoundNBT tokenCompound = controller.serialize(request.getId());
        IntNBT stateCompound = request.getState().serialize();
        CompoundNBT requestedCompound = typeSerialization.apply(controller, request.getRequest());
        ListNBT childrenCompound = new ListNBT();
        for (IToken token : request.getChildren()) {
            childrenCompound.add((Object)controller.serialize(token));
        }
        compound.func_218657_a(NBT_REQUESTER, (INBT)requesterCompound);
        compound.func_218657_a(NBT_TOKEN, (INBT)tokenCompound);
        compound.func_218657_a(NBT_STATE, (INBT)stateCompound);
        compound.func_218657_a(NBT_REQUESTED, (INBT)requestedCompound);
        if (request.hasResult()) {
            compound.func_218657_a(NBT_RESULT, (INBT)typeSerialization.apply(controller, request.getResult()));
        }
        if (request.hasParent()) {
            compound.func_218657_a(NBT_PARENT, (INBT)controller.serialize(request.getParent()));
        }
        compound.func_218657_a(NBT_CHILDREN, (INBT)childrenCompound);
        ListNBT deliveriesList = new ListNBT();
        request.getDeliveries().forEach(itemStack -> deliveriesList.add((Object)itemStack.func_77955_b(new CompoundNBT())));
        compound.func_218657_a(NBT_DELIVERIES, (INBT)deliveriesList);
        return compound;
    }

    public static <T extends IRequestable> void serializeToPacketBuffer(IFactoryController controller, IRequest<T> request, PacketBuffer packetBuffer, IObjectToPackBufferWriter<T> typeSerialization) {
        controller.serialize(packetBuffer, request.getRequester());
        controller.serialize(packetBuffer, request.getId());
        request.getState().serialize(packetBuffer);
        typeSerialization.apply(controller, packetBuffer, request.getRequest());
        packetBuffer.writeInt(request.getChildren().size());
        for (IToken token : request.getChildren()) {
            controller.serialize(packetBuffer, token);
        }
        packetBuffer.writeBoolean(request.hasResult());
        if (request.hasResult()) {
            typeSerialization.apply(controller, packetBuffer, request.getResult());
        }
        packetBuffer.writeBoolean(request.hasParent());
        if (request.hasParent()) {
            controller.serialize(packetBuffer, request.getParent());
        }
        packetBuffer.writeInt(request.getDeliveries().size());
        request.getDeliveries().forEach(arg_0 -> ((PacketBuffer)packetBuffer).func_150788_a(arg_0));
    }

    public static <T extends IRequestable, R extends IRequest<T>> R deserializeFromNBT(IFactoryController controller, CompoundNBT compound, INBTToObjectConverter<T> typeDeserialization, IObjectConstructor<T, R> objectConstructor) {
        IRequester requester = (IRequester)controller.deserialize(compound.func_74775_l(NBT_REQUESTER));
        IToken token = (IToken)controller.deserialize(compound.func_74775_l(NBT_TOKEN));
        RequestState state = RequestState.deserialize((IntNBT)compound.func_74781_a(NBT_STATE));
        IRequestable requested = (IRequestable)typeDeserialization.apply(controller, compound.func_74775_l(NBT_REQUESTED));
        ArrayList childTokens = new ArrayList();
        ListNBT childCompound = compound.func_150295_c(NBT_CHILDREN, 10);
        for (int i = 0; i < childCompound.size(); ++i) {
            childTokens.add(controller.deserialize(childCompound.func_150305_b(i)));
        }
        IRequest request = (IRequest)objectConstructor.construct(requested, token, requester, state);
        request.addChildren(childTokens);
        if (compound.func_150296_c().contains(NBT_PARENT)) {
            request.setParent((IToken)controller.deserialize(compound.func_74775_l(NBT_PARENT)));
        }
        if (compound.func_150296_c().contains(NBT_RESULT)) {
            request.setResult((IRequestable)typeDeserialization.apply(controller, compound.func_74775_l(NBT_RESULT)));
        }
        if (compound.func_150296_c().contains(NBT_DELIVERIES)) {
            ImmutableList.Builder stackBuilder = ImmutableList.builder();
            ListNBT deliveriesList = compound.func_150295_c(NBT_DELIVERIES, 10);
            NBTUtils.streamCompound(deliveriesList).forEach(itemStackCompound -> stackBuilder.add((Object)ItemStack.func_199557_a((CompoundNBT)itemStackCompound)));
            request.overrideCurrentDeliveries((ImmutableList<ItemStack>)stackBuilder.build());
        }
        return (R)request;
    }

    public static <T extends IRequestable, R extends IRequest<T>> R deserializeFromPacketBuffer(IFactoryController controller, PacketBuffer buffer, IPacketBufferToObjectReader<T> typeDeserialization, IObjectConstructor<T, R> objectConstructor) {
        IRequester requester = (IRequester)controller.deserialize(buffer);
        IToken token = (IToken)controller.deserialize(buffer);
        RequestState state = RequestState.deserialize(buffer);
        IRequestable requested = (IRequestable)typeDeserialization.apply(controller, buffer);
        ArrayList childTokens = new ArrayList();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            childTokens.add(controller.deserialize(buffer));
        }
        IRequest request = (IRequest)objectConstructor.construct(requested, token, requester, state);
        request.addChildren(childTokens);
        if (buffer.readBoolean()) {
            request.setResult((IRequestable)typeDeserialization.apply(controller, buffer));
        }
        if (buffer.readBoolean()) {
            request.setParent((IToken)controller.deserialize(buffer));
        }
        ArrayList<ItemStack> deliveries = new ArrayList<ItemStack>();
        int size2 = buffer.readInt();
        for (int i = 0; i < size2; ++i) {
            deliveries.add(buffer.func_150791_c());
        }
        request.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.copyOf(deliveries));
        return (R)request;
    }

    @FunctionalInterface
    public static interface IObjectConstructor<T, O> {
        public O construct(@NotNull T var1, @NotNull IToken<?> var2, @NotNull IRequester var3, @NotNull RequestState var4);
    }

    @FunctionalInterface
    public static interface IPacketBufferToObjectReader<O> {
        public O apply(IFactoryController var1, PacketBuffer var2);
    }

    @FunctionalInterface
    public static interface IObjectToPackBufferWriter<O> {
        public void apply(IFactoryController var1, PacketBuffer var2, O var3);
    }

    @FunctionalInterface
    public static interface INBTToObjectConverter<O> {
        public O apply(IFactoryController var1, CompoundNBT var2);
    }

    @FunctionalInterface
    public static interface IObjectToNBTConverter<O> {
        public CompoundNBT apply(IFactoryController var1, O var2);
    }

    public static final class BurnableRequestFactory
    implements IRequestFactory<Burnable, StandardRequests.BurnableRequest> {
        @Override
        public StandardRequests.BurnableRequest getNewInstance(@NotNull Burnable input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.BurnableRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.BurnableRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.BurnableRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Burnable> getFactoryInputType() {
            return TypeToken.of(Burnable.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.BurnableRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Burnable::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.BurnableRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Burnable::deserialize, (requested, token, requester, requestState) -> (StandardRequests.BurnableRequest)controller.getNewInstance(TypeToken.of(StandardRequests.BurnableRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.BurnableRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, Burnable::serialize);
        }

        @Override
        public StandardRequests.BurnableRequest deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, Burnable::deserialize, (requested, token, requester, requestState) -> (StandardRequests.BurnableRequest)controller.getNewInstance(TypeToken.of(StandardRequests.BurnableRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.BURNABLE_REQUEST_ID;
        }
    }

    public static final class SmeltableOreRequestFactory
    implements IRequestFactory<SmeltableOre, StandardRequests.SmeltAbleOreRequest> {
        @Override
        public StandardRequests.SmeltAbleOreRequest getNewInstance(@NotNull SmeltableOre input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.SmeltAbleOreRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.SmeltAbleOreRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.SmeltAbleOreRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends SmeltableOre> getFactoryInputType() {
            return TypeToken.of(SmeltableOre.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.SmeltAbleOreRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, SmeltableOre::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.SmeltAbleOreRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, SmeltableOre::deserialize, (requested, token, requester, requestState) -> (StandardRequests.SmeltAbleOreRequest)controller.getNewInstance(TypeToken.of(StandardRequests.SmeltAbleOreRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.SmeltAbleOreRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, SmeltableOre::serialize);
        }

        @Override
        public StandardRequests.SmeltAbleOreRequest deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, SmeltableOre::deserialize, (requested, token, requester, requestState) -> (StandardRequests.SmeltAbleOreRequest)controller.getNewInstance(TypeToken.of(StandardRequests.SmeltAbleOreRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.SMELTABLE_ORE_REQUEST_ID;
        }
    }

    public static final class FoodRequestFactory
    implements IRequestFactory<Food, StandardRequests.FoodRequest> {
        @Override
        public StandardRequests.FoodRequest getNewInstance(@NotNull Food input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.FoodRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.FoodRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.FoodRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Food> getFactoryInputType() {
            return TypeToken.of(Food.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.FoodRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Food::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.FoodRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Food::deserialize, (requested, token, requester, requestState) -> (StandardRequests.FoodRequest)controller.getNewInstance(TypeToken.of(StandardRequests.FoodRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.FoodRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, Food::serialize);
        }

        @Override
        public StandardRequests.FoodRequest deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, Food::deserialize, (requested, token, requester, requestState) -> (StandardRequests.FoodRequest)controller.getNewInstance(TypeToken.of(StandardRequests.FoodRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.FOOD_REQUEST_ID;
        }
    }

    public static final class ToolRequestFactory
    implements IRequestFactory<Tool, StandardRequests.ToolRequest> {
        @Override
        public StandardRequests.ToolRequest getNewInstance(@NotNull Tool input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ToolRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.ToolRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ToolRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Tool> getFactoryInputType() {
            return TypeToken.of(Tool.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ToolRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Tool::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ToolRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Tool::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ToolRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ToolRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.ToolRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, Tool::serialize);
        }

        @Override
        public StandardRequests.ToolRequest deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, Tool::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ToolRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ToolRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.TOOL_REQUEST_ID;
        }
    }

    public static final class PublicCraftingRequestFactory
    extends AbstractCraftingRequestFactory<PublicCrafting, StandardRequests.PublicCraftingRequest> {
        public PublicCraftingRequestFactory() {
            super((requested, token, requester, requestState) -> new StandardRequests.PublicCraftingRequest(requester, (IToken<?>)token, requestState, (PublicCrafting)requested), PublicCrafting.class, StandardRequests.PublicCraftingRequest.class, PublicCrafting::serialize, PublicCrafting::deserialize, PublicCrafting::serialize, PublicCrafting::deserialize);
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.PUBLIC_CRAFTING_REQUEST_ID;
        }
    }

    public static final class PrivateCraftingRequestFactory
    extends AbstractCraftingRequestFactory<PrivateCrafting, StandardRequests.PrivateCraftingRequest> {
        public PrivateCraftingRequestFactory() {
            super((requested, token, requester, requestState) -> new StandardRequests.PrivateCraftingRequest(requester, (IToken<?>)token, requestState, (PrivateCrafting)requested), PrivateCrafting.class, StandardRequests.PrivateCraftingRequest.class, PrivateCrafting::serialize, PrivateCrafting::deserialize, PrivateCrafting::serialize, PrivateCrafting::deserialize);
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.PRIVATE_CRAFTING_REQUEST_ID;
        }
    }

    public static abstract class AbstractCraftingRequestFactory<C extends AbstractCrafting, R extends StandardRequests.AbstractCraftingRequest<C>>
    implements IRequestFactory<C, R> {
        private final IObjectConstructor<C, R> constructor;
        private final Class<C> cClass;
        private final Class<R> rClass;
        private final IObjectToNBTConverter<C> nbtSerializer;
        private final INBTToObjectConverter<C> nbtDeserializer;
        private final IObjectToPackBufferWriter<C> packetSerializer;
        private final IPacketBufferToObjectReader<C> packetDeserializer;

        protected AbstractCraftingRequestFactory(IObjectConstructor<C, R> constructor, Class<C> cClass, Class<R> rClass, IObjectToNBTConverter<C> nbtSerializer, INBTToObjectConverter<C> nbtDeserializer, IObjectToPackBufferWriter<C> packetSerializer, IPacketBufferToObjectReader<C> packetDeserializer) {
            this.constructor = constructor;
            this.cClass = cClass;
            this.rClass = rClass;
            this.nbtSerializer = nbtSerializer;
            this.nbtDeserializer = nbtDeserializer;
            this.packetSerializer = packetSerializer;
            this.packetDeserializer = packetDeserializer;
        }

        @Override
        public R getNewInstance(@NotNull C input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return (R)((StandardRequests.AbstractCraftingRequest)this.constructor.construct(input, token, location, initialState));
        }

        @Override
        @NotNull
        public TypeToken<? extends R> getFactoryOutputType() {
            return TypeToken.of(this.rClass);
        }

        @Override
        @NotNull
        public TypeToken<? extends C> getFactoryInputType() {
            return TypeToken.of(this.cClass);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull R r) {
            return StandardRequestFactories.serializeToNBT(controller, r, this.nbtSerializer);
        }

        @Override
        @NotNull
        public R deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) throws Throwable {
            return (R)StandardRequestFactories.deserializeFromNBT(controller, nbt, this.nbtDeserializer, (requested, token, requester, requestState) -> (StandardRequests.AbstractCraftingRequest)controller.getNewInstance(TypeToken.of(this.rClass), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, R input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, this.packetSerializer);
        }

        @Override
        public R deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return (R)StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, this.packetDeserializer, (requested, token, requester, requestState) -> (StandardRequests.AbstractCraftingRequest)controller.getNewInstance(TypeToken.of(this.rClass), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class PickupRequestFactory
    implements IRequestFactory<Pickup, StandardRequests.PickupRequest> {
        @Override
        @NotNull
        public TypeToken<StandardRequests.PickupRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.PickupRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Pickup> getFactoryInputType() {
            return TypeConstants.PICKUP;
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.PickupRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Pickup::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.PickupRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Pickup::deserialize, (requested, token, requester, requestState) -> (StandardRequests.PickupRequest)controller.getNewInstance(TypeToken.of(StandardRequests.PickupRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public StandardRequests.PickupRequest getNewInstance(@NotNull Pickup input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.PickupRequest(location, token, initialState, input);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.PickupRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, Pickup::serialize);
        }

        @Override
        public StandardRequests.PickupRequest deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, Pickup::deserialize, (requested, token, requester, requestState) -> (StandardRequests.PickupRequest)controller.getNewInstance(TypeToken.of(StandardRequests.PickupRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.PICKUP_REQUEST_ID;
        }
    }

    public static final class DeliveryRequestFactory
    implements IRequestFactory<Delivery, StandardRequests.DeliveryRequest> {
        @Override
        @NotNull
        public TypeToken<StandardRequests.DeliveryRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.DeliveryRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Delivery> getFactoryInputType() {
            return TypeConstants.DELIVERY;
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.DeliveryRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Delivery::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.DeliveryRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Delivery::deserialize, (requested, token, requester, requestState) -> (StandardRequests.DeliveryRequest)controller.getNewInstance(TypeToken.of(StandardRequests.DeliveryRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public StandardRequests.DeliveryRequest getNewInstance(@NotNull Delivery input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.DeliveryRequest(location, token, initialState, input);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.DeliveryRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, Delivery::serialize);
        }

        @Override
        public StandardRequests.DeliveryRequest deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, Delivery::deserialize, (requested, token, requester, requestState) -> (StandardRequests.DeliveryRequest)controller.getNewInstance(TypeToken.of(StandardRequests.DeliveryRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.DELIVERY_REQUEST_ID;
        }
    }

    public static final class ItemTagRequestFactory
    implements IRequestFactory<Tag, StandardRequests.ItemTagRequest> {
        @Override
        public StandardRequests.ItemTagRequest getNewInstance(@NotNull Tag input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemTagRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemTagRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemTagRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Tag> getFactoryInputType() {
            return TypeToken.of(Tag.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemTagRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Tag::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemTagRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Tag::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemTagRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemTagRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        @NotNull
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemTagRequest itemTagRequest, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, itemTagRequest, packetBuffer, Tag::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemTagRequest deserialize(@NotNull IFactoryController controller, @NotNull PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, Tag::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemTagRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemTagRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.ITEM_TAG_REQUEST_ID;
        }
    }

    public static final class ItemStackListRequestFactory
    implements IRequestFactory<StackList, StandardRequests.ItemStackListRequest> {
        @Override
        public StandardRequests.ItemStackListRequest getNewInstance(@NotNull StackList input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackListRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackListRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackListRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<StackList> getFactoryInputType() {
            return TypeToken.of(StackList.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackListRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, StackList::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackListRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, StackList::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackListRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackListRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.ItemStackListRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, StackList::serialize);
        }

        @Override
        public StandardRequests.ItemStackListRequest deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, StackList::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackListRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackListRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.ITEM_STACK_LIST_REQUEST_ID;
        }
    }

    public static final class ItemStackRequestFactory
    implements IRequestFactory<Stack, StandardRequests.ItemStackRequest> {
        @Override
        public StandardRequests.ItemStackRequest getNewInstance(@NotNull Stack input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Stack> getFactoryInputType() {
            return TypeToken.of(Stack.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Stack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        @NotNull
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackRequest input, PacketBuffer packetBuffer) {
            StandardRequestFactories.serializeToPacketBuffer(controller, input, packetBuffer, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackRequest deserialize(@NotNull IFactoryController controller, @NotNull PacketBuffer buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromPacketBuffer(controller, buffer, Stack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.ITEM_STACK_REQUEST_ID;
        }
    }
}

