/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requesters.factories;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class BuildingBasedRequesterFactory
implements IFactory<AbstractBuilding, BuildingBasedRequester> {
    @Override
    @NotNull
    public TypeToken<? extends BuildingBasedRequester> getFactoryOutputType() {
        return TypeToken.of(BuildingBasedRequester.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends AbstractBuilding> getFactoryInputType() {
        return TypeToken.of(AbstractBuilding.class);
    }

    @Override
    @NotNull
    public BuildingBasedRequester getNewInstance(@NotNull IFactoryController factoryController, @NotNull AbstractBuilding building, Object ... context) throws IllegalArgumentException {
        if (context.length != 0) {
            throw new IllegalArgumentException("To many context elements. Only 0 supported.");
        }
        ILocation location = factoryController.getNewInstance(TypeConstants.ILOCATION, building.getPosition(), building.getColony().getDimension());
        IToken<?> token = factoryController.getNewInstance(TypeConstants.ITOKEN);
        return new BuildingBasedRequester(location, token);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull BuildingBasedRequester output) {
        return output.serialize(controller);
    }

    @Override
    @NotNull
    public BuildingBasedRequester deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        return BuildingBasedRequester.deserialize(controller, nbt);
    }

    @Override
    public void serialize(IFactoryController controller, BuildingBasedRequester output, PacketBuffer packetBuffer) {
        output.serialize(controller, packetBuffer);
    }

    @Override
    public BuildingBasedRequester deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        return BuildingBasedRequester.deserialize(controller, buffer);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.BUILDER_BASED_REQUESTER_ID;
    }
}

