/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.VisitorData;
import com.minecolonies.coremod.entity.citizen.VisitorCitizen;
import com.minecolonies.coremod.network.messages.client.colony.ColonyVisitorViewDataMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class VisitorManager
implements IVisitorManager {
    public static String TAG_VISIT_MANAGER = "visitManager";
    public static String TAG_VISITORS = "visitors";
    public static String TAG_NEXTID = "nextID";
    private Map<Integer, IVisitorData> visitorMap = new HashMap<Integer, IVisitorData>();
    private boolean isDirty = false;
    private final IColony colony;
    private int nextVisitorID = -1;

    public VisitorManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public void registerCivilian(AbstractCivilianEntity visitor) {
        if (visitor.getCivilianID() == 0 || this.visitorMap.get(visitor.getCivilianID()) == null) {
            visitor.func_70106_y();
            return;
        }
        ICitizenData data = this.visitorMap.get(visitor.getCivilianID());
        Optional<AbstractEntityCitizen> existingCitizen = data.getEntity();
        if (!existingCitizen.isPresent()) {
            data.setEntity(visitor);
            visitor.setCivilianData(data);
            return;
        }
        if (existingCitizen.get() == visitor) {
            return;
        }
        if (visitor.func_70089_S()) {
            existingCitizen.get().func_70106_y();
            data.setEntity(visitor);
            visitor.setCivilianData(data);
            return;
        }
        visitor.func_70106_y();
    }

    @Override
    public void unregisterCivilian(AbstractCivilianEntity entity) {
        ICitizenData data = this.visitorMap.get(entity.getCivilianID());
        if (data != null && data.getEntity().isPresent() && data.getEntity().get() == entity) {
            this.visitorMap.get(entity.getCivilianID()).setEntity(null);
        }
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        if (compound.func_74764_b(TAG_VISIT_MANAGER)) {
            CompoundNBT visitorManagerNBT = compound.func_74775_l(TAG_VISIT_MANAGER);
            ListNBT citizenList = visitorManagerNBT.func_150295_c(TAG_VISITORS, 10);
            for (INBT citizen : citizenList) {
                IVisitorData data = VisitorData.loadVisitorFromNBT(this.colony, (CompoundNBT)citizen);
                this.visitorMap.put(data.getId(), data);
            }
            this.nextVisitorID = visitorManagerNBT.func_74762_e(TAG_NEXTID);
        }
        this.markDirty();
    }

    @Override
    public void write(@NotNull CompoundNBT compoundNBT) {
        CompoundNBT visitorManagerNBT = new CompoundNBT();
        ListNBT citizenList = new ListNBT();
        for (Map.Entry<Integer, IVisitorData> entry : this.visitorMap.entrySet()) {
            citizenList.add((Object)entry.getValue().serializeNBT());
        }
        visitorManagerNBT.func_218657_a(TAG_VISITORS, (INBT)citizenList);
        visitorManagerNBT.func_74768_a(TAG_NEXTID, this.nextVisitorID);
        compoundNBT.func_218657_a(TAG_VISIT_MANAGER, (INBT)visitorManagerNBT);
    }

    @Override
    public void sendPackets(@NotNull Set<ServerPlayerEntity> closeSubscribers, @NotNull Set<ServerPlayerEntity> newSubscribers) {
        boolean refresh;
        HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>(newSubscribers);
        players.addAll(closeSubscribers);
        HashSet<Object> toSend = new HashSet();
        boolean bl = refresh = !newSubscribers.isEmpty() || this.isDirty;
        if (refresh) {
            toSend = new HashSet<IVisitorData>(this.visitorMap.values());
            for (IVisitorData data : this.visitorMap.values()) {
                data.clearDirty();
            }
            this.clearDirty();
        } else {
            for (IVisitorData data : this.visitorMap.values()) {
                if (data.isDirty()) {
                    toSend.add(data);
                }
                data.clearDirty();
            }
        }
        if (toSend.isEmpty()) {
            return;
        }
        ColonyVisitorViewDataMessage message = new ColonyVisitorViewDataMessage(this.colony, toSend, refresh);
        for (ServerPlayerEntity player : players) {
            Network.getNetwork().sendToPlayer(message, player);
        }
    }

    @Override
    @NotNull
    public Map<Integer, ICivilianData> getCivilianDataMap() {
        return Collections.unmodifiableMap(this.visitorMap);
    }

    public IVisitorData getCivilian(int citizenId) {
        return this.visitorMap.get(citizenId);
    }

    @Override
    public <T extends IVisitorData> T getVisitor(int citizenId) {
        return (T)this.visitorMap.get(citizenId);
    }

    public IVisitorData spawnOrCreateCivilian(ICivilianData data, World world, BlockPos spawnPos, boolean force) {
        VisitorCitizen citizenEntity;
        if (!WorldUtil.isEntityBlockLoaded((IWorld)world, spawnPos)) {
            return (IVisitorData)data;
        }
        if (data == null) {
            data = this.createAndRegisterCivilianData();
        }
        if ((citizenEntity = (VisitorCitizen)ModEntities.VISITOR.func_200721_a(this.colony.getWorld())) == null) {
            return (IVisitorData)data;
        }
        citizenEntity.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.1, (double)spawnPos.func_177952_p() + 0.5);
        world.func_217376_c((Entity)citizenEntity);
        citizenEntity.getCitizenColonyHandler().registerWithColony(data.getColony().getID(), data.getId());
        return (IVisitorData)data;
    }

    @Override
    public IVisitorData createAndRegisterCivilianData() {
        this.markDirty();
        VisitorData data = new VisitorData(this.nextVisitorID--, this.colony);
        data.initForNewCivilian();
        this.visitorMap.put(data.getId(), data);
        return data;
    }

    @Override
    public void removeCivilian(@NotNull ICivilianData citizen) {
        IVisitorData data = this.visitorMap.remove(citizen.getId());
        if (data != null && data.getEntity().isPresent()) {
            data.getEntity().get().func_70106_y();
        }
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        if (colony.hasTownHall()) {
            for (IVisitorData data : this.visitorMap.values()) {
                data.updateEntityIfNecessary();
            }
        }
    }
}

