/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobStructure<AI extends AbstractAISkeleton<J>, J extends AbstractJobStructure<AI, J>>
extends AbstractJob<AI, J> {
    private static final String TAG_WORK_ORDER = "workorder";
    private int workOrderId;
    protected Blueprint blueprint;

    public AbstractJobStructure(ICitizenData entity) {
        super(entity);
    }

    public boolean hasBlueprint() {
        return this.blueprint != null;
    }

    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    public void setBlueprint(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        return this.workOrderId != 0;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.workOrderId != 0) {
            compound.func_74768_a(TAG_WORK_ORDER, this.workOrderId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains(TAG_WORK_ORDER)) {
            this.workOrderId = compound.func_74762_e(TAG_WORK_ORDER);
        }
    }

    public void complete() {
        this.getWorkOrder().onCompleted(this.getCitizen().getColony(), this.getCitizen());
        if (this.blueprint != null) {
            CompoundNBT[][][] tileEntityData = this.blueprint.getTileEntities();
            for (short x = 0; x < this.blueprint.getSizeX(); x = (short)(x + 1)) {
                for (short y = 0; y < this.blueprint.getSizeY(); y = (short)(y + 1)) {
                    for (short z = 0; z < this.blueprint.getSizeZ(); z = (short)(z + 1)) {
                        CompoundNBT compoundNBT = tileEntityData[y][z][x];
                        if (compoundNBT == null || !compoundNBT.func_74764_b("blueprintDataProvider")) continue;
                        BlockPos tePos = this.getWorkOrder().getLocation().func_177973_b((Vector3i)this.blueprint.getPrimaryBlockOffset()).func_177982_a((int)x, (int)y, (int)z);
                        TileEntity te = this.getColony().getWorld().func_175625_s(tePos);
                        if (!(te instanceof IBlueprintDataProvider)) continue;
                        ((IBlueprintDataProvider)te).readSchematicDataFromNBT(compoundNBT);
                        ((ServerWorld)this.getColony().getWorld()).func_72863_F().func_217217_a(tePos);
                        te.func_70296_d();
                    }
                }
            }
        }
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
        this.setBlueprint(null);
    }

    public IWorkOrder getWorkOrder() {
        return this.getColony().getWorkManager().getWorkOrder(this.workOrderId, IWorkOrder.class);
    }

    private void resetNeededItems() {
        IBuilding workerBuilding = this.getCitizen().getWorkBuilding();
        if (workerBuilding instanceof AbstractBuildingStructureBuilder) {
            ((AbstractBuildingStructureBuilder)workerBuilding).resetNeededResources();
        }
    }

    public void setWorkOrder(@Nullable IWorkOrder order) {
        if (order == null) {
            this.workOrderId = 0;
            this.resetNeededItems();
        } else {
            this.workOrderId = order.getID();
        }
    }
}

