/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.crafting.GenericRecipeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecipeAnalyzer {
    public static Map<CraftingType, List<IGenericRecipe>> buildVanillaRecipesMap(@NotNull RecipeManager recipeManager, @Nullable World world) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CraftingType type : MinecoloniesAPIProxy.getInstance().getCraftingTypeRegistry().getValues()) {
            List<IGenericRecipe> recipes = type.findRecipes(recipeManager, world);
            builder.put((Object)type, recipes);
        }
        return builder.build();
    }

    @NotNull
    public static List<IGenericRecipe> findRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla, @NotNull ICraftingBuildingModule crafting) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (Map.Entry<CraftingType, List<IGenericRecipe>> entry : vanilla.entrySet()) {
            if (!crafting.canLearn(entry.getKey())) continue;
            for (IGenericRecipe recipe : entry.getValue()) {
                IGenericRecipe safeRecipe = GenericRecipeUtils.filterInputs(recipe, crafting.getIngredientValidator());
                if (!crafting.isRecipeCompatible(safeRecipe)) continue;
                recipes.add(safeRecipe);
            }
        }
        for (CustomRecipe customRecipe : CustomRecipeManager.getInstance().getRecipes(crafting.getCustomRecipeKey())) {
            IRecipeStorage recipeStorage = customRecipe.getRecipeStorage();
            if (!recipeStorage.getAlternateOutputs().isEmpty()) {
                recipes.removeIf(r -> ItemStackUtils.compareItemStacksIgnoreStackSize(recipeStorage.getPrimaryOutput(), r.getPrimaryOutput()));
                recipes.removeIf(r -> recipeStorage.getAlternateOutputs().stream().anyMatch(s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, r.getPrimaryOutput())));
            }
            recipes.add(GenericRecipeUtils.create(customRecipe, recipeStorage));
        }
        recipes.addAll(crafting.getAdditionalRecipesForDisplayPurposesOnly());
        return recipes;
    }

    private RecipeAnalyzer() {
    }
}

