/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.IItemStorageFactory;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class ItemStorageFactory
implements IItemStorageFactory {
    private static final String TAG_SIZE = "size";
    private static final String TAG_STACK = "stack";
    private static final String TAG_SHOULDIGNORENBT = "ignoreNBT";
    private static final String TAG_SHOULDIGNOREDAMAGE = "ignoreDamage";

    @Override
    @NotNull
    public TypeToken<ItemStorage> getFactoryOutputType() {
        return TypeConstants.ITEMSTORAGE;
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public ItemStorage getNewInstance(@NotNull ItemStack stack, int size, boolean ignoreDamage, boolean ignoreNBT) {
        ItemStorage newItem = new ItemStorage(stack, ignoreDamage, ignoreNBT);
        newItem.setAmount(size);
        return newItem;
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull ItemStorage storage) {
        CompoundNBT compound = new CompoundNBT();
        @NotNull CompoundNBT stackTag = new CompoundNBT();
        storage.getItemStack().func_77955_b(stackTag);
        compound.func_218657_a(TAG_STACK, (INBT)stackTag);
        compound.func_74768_a(TAG_SIZE, storage.getAmount());
        compound.func_74757_a(TAG_SHOULDIGNOREDAMAGE, storage.ignoreDamageValue());
        compound.func_74757_a(TAG_SHOULDIGNORENBT, storage.ignoreNBT());
        return compound;
    }

    @Override
    @NotNull
    public ItemStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(TAG_STACK));
        int size = nbt.func_74762_e(TAG_SIZE);
        boolean ignoreNBT = nbt.func_74767_n(TAG_SHOULDIGNORENBT);
        boolean ignoreDamage = nbt.func_74767_n(TAG_SHOULDIGNOREDAMAGE);
        return this.getNewInstance(stack, size, ignoreDamage, ignoreNBT);
    }

    @Override
    public void serialize(IFactoryController controller, ItemStorage input, PacketBuffer packetBuffer) {
        packetBuffer.func_150788_a(input.getItemStack());
        packetBuffer.func_150787_b(input.getAmount());
        packetBuffer.writeBoolean(input.ignoreDamageValue());
        packetBuffer.writeBoolean(input.ignoreNBT());
    }

    @Override
    public ItemStorage deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        ItemStack stack = buffer.func_150791_c();
        int size = buffer.func_150792_a();
        boolean ignoreDamage = buffer.readBoolean();
        boolean ignoreNBT = buffer.readBoolean();
        return this.getNewInstance(stack, size, ignoreDamage, ignoreNBT);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.ITEM_STORAGE_ID;
    }
}

