/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.amazonevent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.mobs.amazons.EntityAmazonChief;
import com.minecolonies.coremod.entity.mobs.amazons.EntityAmazonSpearman;
import com.minecolonies.coremod.entity.mobs.amazons.EntityArcherAmazon;
import com.minecolonies.coremod.network.messages.client.PlayAudioMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AmazonRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation AMAZON_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "amazon_raid");
    private int musicCooldown = 0;

    public AmazonRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return AMAZON_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.func_70089_S()) {
            entity.func_70106_y();
            return;
        }
        if (entity instanceof EntityAmazonChief && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityArcherAmazon && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityAmazonSpearman && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.func_110124_au());
            return;
        }
        entity.func_70106_y();
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.func_186743_c(true);
    }

    @Override
    protected IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent("com.minecolonies.coremod.raid.amazon.name");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (--this.musicCooldown <= 0) {
            PlayAudioMessage.sendToAll(this.getColony(), true, true, new PlayAudioMessage(RaidSounds.AMAZON_RAID));
            this.musicCooldown = 20;
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob)) {
            return;
        }
        if (entity instanceof EntityAmazonChief) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherAmazon) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityAmazonSpearman) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static AmazonRaidEvent loadFromNBT(IColony colony, CompoundNBT compound) {
        AmazonRaidEvent event = new AmazonRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.AMAZONSPEARMAN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.AMAZON;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.AMAZONCHIEF;
    }
}

