/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesNamedGrave;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingGraveyard
extends AbstractBuilding {
    private static final String GRAVEYARD = "graveyard";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_VISUAL_GRAVES = "visualgraves";
    private static final String TAG_VISUAL_GRAVES_BLOCKPOS = "visualgravesblockpos";
    private static final String TAG_VISUAL_GRAVES_FACING = "visualgravesfacing";
    private static final String TAG_CURRENT_GRAVE = "currentGRAVE";
    @Nullable
    private BlockPos currentGrave;
    private Set<com.minecolonies.api.util.Tuple<BlockPos, Direction>> visualGravePositions = new HashSet<com.minecolonies.api.util.Tuple<BlockPos, Direction>>();

    public BuildingGraveyard(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.func_77973_b() == Items.field_190929_cY, new Tuple((Object)2, (Object)true));
    }

    public void ClearCurrentGrave() {
        this.currentGrave = null;
    }

    @Nullable
    public BlockPos getGraveToWorkOn() {
        if (this.currentGrave != null) {
            TileEntity tileEntity;
            if (WorldUtil.isBlockLoaded((IWorld)this.colony.getWorld(), this.currentGrave) && (tileEntity = this.getColony().getWorld().func_175625_s(this.currentGrave)) instanceof TileEntityGrave) {
                return this.currentGrave;
            }
            this.colony.getGraveManager().unReserveGrave(this.currentGrave);
            this.currentGrave = null;
        }
        this.currentGrave = this.colony.getGraveManager().reserveNextFreeGrave();
        return this.currentGrave;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains(TAG_CURRENT_GRAVE)) {
            this.currentGrave = BlockPosUtil.read(compound, TAG_CURRENT_GRAVE);
        }
        this.visualGravePositions.clear();
        ListNBT visualGraveTagList = compound.func_150295_c(TAG_VISUAL_GRAVES, 10);
        for (int i = 0; i < visualGraveTagList.size(); ++i) {
            CompoundNBT graveCompound = visualGraveTagList.func_150305_b(i);
            BlockPos graveLocation = BlockPosUtil.read(graveCompound, TAG_VISUAL_GRAVES_BLOCKPOS);
            Direction graveFacing = Direction.func_176739_a((String)graveCompound.func_74779_i(TAG_VISUAL_GRAVES_FACING));
            this.visualGravePositions.add(new com.minecolonies.api.util.Tuple<BlockPos, Direction>(graveLocation, graveFacing));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.currentGrave != null) {
            BlockPosUtil.write(compound, TAG_CURRENT_GRAVE, this.currentGrave);
        }
        @NotNull ListNBT visualGraveTagList = new ListNBT();
        for (com.minecolonies.api.util.Tuple<BlockPos, Direction> vgp : this.visualGravePositions) {
            @NotNull CompoundNBT graveCompound = new CompoundNBT();
            BlockPosUtil.write(graveCompound, TAG_VISUAL_GRAVES_BLOCKPOS, vgp.getA());
            graveCompound.func_74778_a(TAG_VISUAL_GRAVES_FACING, vgp.getB().func_176742_j());
            visualGraveTagList.add((Object)graveCompound);
        }
        compound.func_218657_a(TAG_VISUAL_GRAVES, (INBT)visualGraveTagList);
        return compound;
    }

    public Set<com.minecolonies.api.util.Tuple<BlockPos, Direction>> getGravePositions() {
        return this.visualGravePositions;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return GRAVEYARD;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState state, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(state, pos, world);
        if (state.func_177230_c() == ModBlocks.blockNamedGrave) {
            this.visualGravePositions.add(new com.minecolonies.api.util.Tuple<BlockPos, Comparable>(pos, state.func_177229_b((Property)AbstractBlockMinecoloniesNamedGrave.FACING)));
        }
    }

    public com.minecolonies.api.util.Tuple<BlockPos, Direction> getRandomFreeVisualGravePos() {
        if (this.visualGravePositions.isEmpty()) {
            return null;
        }
        ArrayList<com.minecolonies.api.util.Tuple<BlockPos, Direction>> availablePos = new ArrayList<com.minecolonies.api.util.Tuple<BlockPos, Direction>>();
        for (com.minecolonies.api.util.Tuple<BlockPos, Direction> tuple : this.visualGravePositions) {
            if (!this.getColony().getWorld().func_180495_p(tuple.getA()).func_196958_f()) continue;
            availablePos.add(tuple);
        }
        if (availablePos.isEmpty()) {
            return null;
        }
        Collections.shuffle(availablePos);
        return (com.minecolonies.api.util.Tuple)availablePos.get(0);
    }
}

