/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFlorist
extends AbstractBuilding {
    private static final String FLORIST = "florist";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final List<BlockPos> plantGround = new ArrayList<BlockPos>();

    public BuildingFlorist(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.func_77973_b() == ModItems.compost, new Tuple((Object)64, (Object)true));
    }

    public List<BlockPos> getPlantGround() {
        return ImmutableList.copyOf(this.plantGround);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FLORIST;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockCompostedDirt && !this.plantGround.contains(pos)) {
            this.plantGround.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT compostBinTagList = compound.func_150295_c("plantGround", 10);
        for (int i = 0; i < compostBinTagList.size(); ++i) {
            this.plantGround.add(NBTUtil.func_186861_c((CompoundNBT)compostBinTagList.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT compostBinTagList = new ListNBT();
        for (BlockPos entry : this.plantGround) {
            @NotNull CompoundNBT compostBinCompound = new CompoundNBT();
            compostBinCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            compostBinTagList.add((Object)compostBinCompound);
        }
        compound.func_218657_a("plantGround", (INBT)compostBinTagList);
        return compound;
    }

    public void removePlantableGround(BlockPos pos) {
        this.plantGround.remove(pos);
    }

    @Nullable
    public ItemStack getFlowerToGrow() {
        List stacks = BuildingFlorist.getPlantablesForBuildingLevel(this.getBuildingLevel()).stream().filter(stack -> !this.getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers")).isItemInList((ItemStorage)stack)).collect(Collectors.toList());
        if (stacks.isEmpty()) {
            return null;
        }
        return ((ItemStorage)stacks.get(MathUtils.RANDOM.nextInt(stacks.size()))).getItemStack();
    }

    public static Set<ItemStorage> getPlantablesForBuildingLevel(int level) {
        switch (level) {
            case 0: 
            case 1: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(storage -> storage.getItem() == Items.field_221620_aV || storage.getItem() == Items.field_221619_aU).collect(Collectors.toSet());
            }
            case 2: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(itemStorage -> itemStorage.getItem().func_206844_a((ITag)ItemTags.field_219770_E)).collect(Collectors.toSet());
            }
        }
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables();
    }
}

