/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerLevelManagementModule
extends AbstractBuildingModule
implements IPersistentModule {
    @NotNull
    private final List<Level> levels = new ArrayList<Level>();
    private int currentLevel = 0;
    @Nullable
    private Node activeNode = null;
    @Nullable
    private Node oldNode = null;
    private int startingLevelShaft = 0;

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        this.startingLevelShaft = compound.func_74762_e("newStartingLevelShaft");
        this.currentLevel = compound.func_74762_e("currentLevel");
        ListNBT levelTagList = compound.func_150295_c("levels", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            this.levels.add(new Level(levelTagList.func_150305_b(i)));
        }
        if (compound.func_150296_c().contains("activeNodeNode")) {
            this.activeNode = Node.createFromNBT(compound.func_74775_l("activeNodeNode"));
        } else if (compound.func_150296_c().contains("oldNodeNode")) {
            this.oldNode = Node.createFromNBT(compound.func_74775_l("oldNodeNode"));
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        CompoundNBT nodeCompound;
        compound.func_74768_a("newStartingLevelShaft", this.startingLevelShaft);
        compound.func_74768_a("currentLevel", this.currentLevel);
        @NotNull ListNBT levelTagList = new ListNBT();
        for (Level level : this.levels) {
            @NotNull CompoundNBT levelCompound = new CompoundNBT();
            level.write(levelCompound);
            levelTagList.add((Object)levelCompound);
        }
        compound.func_218657_a("levels", (INBT)levelTagList);
        if (this.activeNode != null) {
            nodeCompound = new CompoundNBT();
            this.activeNode.write(nodeCompound);
            compound.func_218657_a("activeNodeNode", (INBT)nodeCompound);
        }
        if (this.oldNode != null) {
            nodeCompound = new CompoundNBT();
            this.oldNode.write(nodeCompound);
            compound.func_218657_a("oldNodeNode", (INBT)nodeCompound);
        }
    }

    @Override
    public void serializeToView(PacketBuffer buf) {
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.levels.size());
        for (Level level : this.levels) {
            buf.writeInt(level.getNumberOfBuiltNodes());
            buf.writeInt(level.getDepth());
        }
        List<WorkOrderMiner> list = this.building.getColony().getWorkManager().getOrderedList(WorkOrderMiner.class, this.building.getPosition());
        buf.writeInt(list.size());
        for (WorkOrderMiner wo : list) {
            wo.serializeViewNetworkData(buf);
        }
    }

    public void addLevel(Level currentLevel) {
        this.levels.add(currentLevel);
    }

    public int getNumberOfLevels() {
        return this.levels.size();
    }

    @Nullable
    public Level getCurrentLevel() {
        if (this.currentLevel >= 0 && this.currentLevel < this.levels.size()) {
            return this.levels.get(this.currentLevel);
        }
        return null;
    }

    public int getLevelId(Level level) {
        return this.levels.indexOf(level);
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
        this.activeNode = null;
        this.oldNode = null;
    }

    public int getStartingLevelShaft() {
        if (this.levels.isEmpty()) {
            return this.startingLevelShaft;
        }
        return this.levels.get(this.levels.size() - 1).getDepth() - 6;
    }

    @Nullable
    public Node getActiveNode() {
        if (this.levels.isEmpty()) {
            return null;
        }
        Node calcNode = this.activeNode;
        if (this.activeNode == null || this.activeNode.getStatus() == Node.NodeStatus.COMPLETED) {
            if (this.currentLevel >= this.levels.size()) {
                this.currentLevel = this.levels.size() - 1;
            }
            calcNode = this.levels.get(this.currentLevel).getRandomNode(this.oldNode);
        }
        if (this.activeNode != calcNode) {
            this.activeNode = calcNode;
        }
        return this.activeNode;
    }

    public void setActiveNode(@Nullable Node activeNode) {
        this.activeNode = activeNode;
    }

    public void setOldNode(@Nullable Node oldNode) {
        this.oldNode = oldNode;
    }

    public void setStartingLevelShaft(int level) {
        this.startingLevelShaft = level;
    }

    public void repairLevel(int level) {
        if (this.building instanceof BuildingMiner) {
            BlockPos ladderPos = ((BuildingMiner)this.building).getLadderLocation();
            BlockPos vector = ladderPos.func_177973_b((Vector3i)((BuildingMiner)this.building).getCobbleLocation());
            int xOffset = 3 * vector.func_177958_n();
            int zOffset = 3 * vector.func_177952_p();
            BuildingMiner.initStructure(null, 0, new BlockPos(ladderPos.func_177958_n() + xOffset, this.levels.get(level).getDepth(), ladderPos.func_177952_p() + zOffset), (BuildingMiner)this.building, this.building.getColony().getWorld(), null);
        }
    }

    public List<Level> getLevels() {
        return this.levels;
    }
}

