/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorkerModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ChildrenBuildingModule
extends WorkerBuildingModule
implements IBuildingEventsModule,
ITickingModule,
IPersistentModule,
IBuildingWorkerModule,
ICreatesResolversModule {
    public ChildrenBuildingModule(JobEntry entry, Skill primary, Skill secondary, boolean canWorkingDuringRain, Function<IBuilding, Integer> sizeLimit) {
        super(entry, primary, secondary, canWorkingDuringRain, sizeLimit);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && (this.building.getBuildingLevel() > 0 && this.building.isBuilt() || this.building instanceof BuildingBuilder) && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            for (ICitizenData data : colony.getCitizenManager().getCitizens()) {
                if (!data.isChild() || data.getWorkBuilding() != null) continue;
                this.assignCitizen(data);
            }
        }
        for (ICitizenData citizenData : new ArrayList<ICitizenData>(this.getAssignedCitizen())) {
            if (citizenData.isChild()) continue;
            this.removeCitizen(citizenData);
        }
    }
}

