/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.tileentities.TileEntityNamedGrave;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityNamedGraveRenderer
extends TileEntityRenderer<TileEntityNamedGrave> {
    private static final int BASIC_ROTATION = 90;
    private static final int ROTATE_EAST = 1;
    private static final int ROTATE_NORTH = 2;
    private static final int ROTATE_WEST = 3;
    private final int textColor = NativeImage.func_227787_a_((int)0, (int)220, (int)220, (int)220);

    public TileEntityNamedGraveRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(@NotNull TileEntityNamedGrave tileEntity, float partialTicks, MatrixStack matrixStack, @NotNull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockState state;
        matrixStack.func_227860_a_();
        if (tileEntity != null && (state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v())).func_177230_c() == ModBlocks.blockNamedGrave) {
            Direction facing = (Direction)state.func_177229_b((Property)AbstractBlockMinecoloniesDefault.FACING);
            switch (facing) {
                case NORTH: {
                    matrixStack.func_227861_a_(0.5, (double)1.18f, (double)0.48f);
                    matrixStack.func_227862_a_(0.006f, -0.006f, 0.006f);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    break;
                }
                case SOUTH: {
                    matrixStack.func_227861_a_(0.5, (double)1.18f, (double)0.54f);
                    matrixStack.func_227862_a_(0.006f, -0.006f, 0.006f);
                    break;
                }
                case EAST: {
                    matrixStack.func_227861_a_((double)0.54f, (double)1.18f, 0.5);
                    matrixStack.func_227862_a_(0.006f, -0.006f, 0.006f);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                    break;
                }
                case WEST: {
                    matrixStack.func_227861_a_((double)0.48f, (double)1.18f, 0.5);
                    matrixStack.func_227862_a_(0.006f, -0.006f, 0.006f);
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                }
            }
            if (tileEntity.getTextLines().isEmpty()) {
                this.renderText(matrixStack, buffer, combinedLight, "Unknown Citizen", 0);
            } else {
                for (int i = 0; i < tileEntity.getTextLines().size(); ++i) {
                    this.renderText(matrixStack, buffer, combinedLight, tileEntity.getTextLines().get(i), i);
                }
            }
        }
        matrixStack.func_227865_b_();
    }

    private void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, String text, int line) {
        IReorderingProcessor iReorderingProcessor;
        int maxSize = 20;
        if (text.length() > 20) {
            text = text.substring(0, 20);
        }
        if ((iReorderingProcessor = IReorderingProcessor.func_242239_a((String)text, (Style)Style.field_240709_b_)) != null) {
            FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
            float x = -fontRenderer.func_243245_a(iReorderingProcessor) / 2;
            fontRenderer.func_238416_a_(iReorderingProcessor, x, (float)line * 10.0f, this.textColor, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        }
    }

    public boolean shouldRenderOffScreen(TileEntityNamedGrave tileEntityMBE21) {
        return false;
    }
}

