/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.colonyEvents.descriptions.IBuildingEventDescription;
import com.minecolonies.api.colony.colonyEvents.descriptions.ICitizenEventDescription;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenDiedEvent;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class WindowInfoPage
extends AbstractWindowTownHall {
    private ScrollingList eventList;
    private boolean permissionEvents;

    public WindowInfoPage(BuildingTownHall.View building) {
        super(building, "layoutinfo.xml");
        this.registerButton("permissionEvents", this::permissionEventsClicked);
        this.registerButton("addfakeplayer", this::addPlayerToColonyClicked);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.createAndSetStatistics();
        this.fillEventsList();
    }

    private void createAndSetStatistics() {
        DecimalFormat df = new DecimalFormat("#.#");
        df.setRoundingMode(RoundingMode.CEILING);
        String roundedHappiness = df.format(((ITownHallView)this.building).getColony().getOverallHappiness());
        ((Text)this.findPaneOfTypeByID("happinessLevel", Text.class)).setText(roundedHappiness);
        int citizensSize = ((ITownHallView)this.building).getColony().getCitizens().size();
        int citizensCap = MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(ResearchConstants.CITIZEN_CAP) ? (int)Math.min((double)((Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get()).intValue(), 25.0 + ((ITownHallView)this.building).getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CITIZEN_CAP)) : (Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get();
        Text totalCitizenLabel = (Text)this.findPaneOfTypeByID("totalCitizens", Text.class);
        totalCitizenLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.totalcitizens.count", new Object[]{citizensSize, Math.max(citizensSize, ((ITownHallView)this.building).getColony().getCitizenCountLimit())}));
        ArrayList<TranslationTextComponent> hoverText = new ArrayList<TranslationTextComponent>();
        if ((double)citizensSize < (double)citizensCap * 0.9 && (double)citizensSize < (double)((ITownHallView)this.building).getColony().getCitizenCountLimit() * 0.9) {
            totalCitizenLabel.setColors(DARKGREEN);
        } else if (citizensSize < citizensCap) {
            hoverText.add(new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.totalcitizens.houselimited", new Object[]{((ITownHallView)this.building).getColony().getName()}));
            totalCitizenLabel.setColors(ORANGE);
        } else {
            if (citizensCap < (Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get()) {
                hoverText.add(new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.totalcitizens.researchlimited", new Object[]{((ITownHallView)this.building).getColony().getName()}));
            } else {
                hoverText.add(new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.totalcitizens.configlimited", new Object[]{((ITownHallView)this.building).getColony().getName()}));
            }
            totalCitizenLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.totalcitizens.count", new Object[]{citizensSize, citizensCap}));
            totalCitizenLabel.setColors(RED);
        }
        PaneBuilders.tooltipBuilder().hoverPane((Pane)totalCitizenLabel).build().setText(hoverText);
        int children = 0;
        HashMap<String, Tuple<Integer, Integer>> jobMaxCountMap = new HashMap<String, Tuple<Integer, Integer>>();
        for (IBuildingView iBuildingView : ((ITownHallView)this.building).getColony().getBuildings()) {
            if (!(iBuildingView instanceof AbstractBuildingView)) continue;
            for (WorkerBuildingModuleView module : iBuildingView.getModuleViews(WorkerBuildingModuleView.class)) {
                int max = module.getMaxInhabitants();
                int workers = module.getAssignedCitizens().size();
                String jobName = module.getJobDisplayName().toLowerCase(Locale.ENGLISH);
                Tuple<Integer, Integer> tuple = jobMaxCountMap.getOrDefault(jobName, new Tuple<Integer, Integer>(0, 0));
                jobMaxCountMap.put(jobName, new Tuple<Integer, Integer>(tuple.getA() + workers, tuple.getB() + max));
            }
        }
        int unemployedCount = 0;
        for (ICitizenDataView iCitizenDataView : ((ITownHallView)this.building).getColony().getCitizens().values()) {
            if (iCitizenDataView.isChild()) {
                ++children;
                continue;
            }
            if (iCitizenDataView.getJobView() != null) continue;
            ++unemployedCount;
        }
        TranslationTextComponent translationTextComponent = new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.unemployed", new Object[]{unemployedCount});
        TranslationTextComponent numberOfKids = new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.childs", new Object[]{children});
        ScrollingList list = (ScrollingList)this.findPaneOfTypeByID("citizen-stats", ScrollingList.class);
        if (list == null) {
            return;
        }
        final int maxJobs = jobMaxCountMap.size();
        final ArrayList theList = new ArrayList(jobMaxCountMap.entrySet());
        theList.sort(Map.Entry.comparingByKey());
        list.setDataProvider(new ScrollingList.DataProvider((ITextComponent)translationTextComponent, (ITextComponent)numberOfKids){
            final /* synthetic */ ITextComponent val$numberOfUnemployed;
            final /* synthetic */ ITextComponent val$numberOfKids;
            {
                this.val$numberOfUnemployed = iTextComponent;
                this.val$numberOfKids = iTextComponent2;
            }

            public int getElementCount() {
                return maxJobs + 2;
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Text label = (Text)rowPane.findPaneOfTypeByID("citizensAmount", Text.class);
                if (index < theList.size()) {
                    Map.Entry entry = (Map.Entry)theList.get(index);
                    TranslationTextComponent job = new TranslationTextComponent((String)entry.getKey());
                    TranslationTextComponent numberOfWorkers = new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.population.each", new Object[]{job, ((Tuple)entry.getValue()).getA(), ((Tuple)entry.getValue()).getB()});
                    label.setText((ITextComponent)numberOfWorkers);
                } else if (index == maxJobs + 1) {
                    label.setText(this.val$numberOfUnemployed);
                } else {
                    label.setText(this.val$numberOfKids);
                }
            }
        });
    }

    private void fillEventsList() {
        this.eventList = (ScrollingList)this.findPaneOfTypeByID("eventsList", ScrollingList.class);
        this.eventList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowInfoPage.this.permissionEvents ? ((ITownHallView)WindowInfoPage.this.building).getPermissionEvents().size() : ((ITownHallView)WindowInfoPage.this.building).getColonyEvents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Text nameLabel = (Text)rowPane.findPaneOfTypeByID("name", Text.class);
                Text actionLabel = (Text)rowPane.findPaneOfTypeByID("action", Text.class);
                if (WindowInfoPage.this.permissionEvents) {
                    List<PermissionEvent> permissionEvents = ((ITownHallView)WindowInfoPage.this.building).getPermissionEvents();
                    Collections.reverse(permissionEvents);
                    PermissionEvent event = permissionEvents.get(index);
                    nameLabel.setText(event.getName() + (event.getId() == null ? " <fake>" : ""));
                    ((Text)rowPane.findPaneOfTypeByID("pos", Text.class)).setText(event.getPosition().func_177958_n() + " " + event.getPosition().func_177956_o() + " " + event.getPosition().func_177952_p());
                    if (event.getId() == null) {
                        ((Button)rowPane.findPaneOfTypeByID("addfakeplayer", Button.class)).hide();
                    }
                    actionLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.permission." + event.getAction().toString().toLowerCase(Locale.US)));
                } else {
                    List<IColonyEventDescription> colonyEvents = ((ITownHallView)WindowInfoPage.this.building).getColonyEvents();
                    Collections.reverse(colonyEvents);
                    IColonyEventDescription event = colonyEvents.get(index);
                    if (event instanceof CitizenDiedEvent) {
                        actionLabel.setText(((CitizenDiedEvent)event).getDeathCause());
                    } else {
                        actionLabel.setText(event.getName());
                    }
                    if (event instanceof ICitizenEventDescription) {
                        nameLabel.setText(((ICitizenEventDescription)event).getCitizenName());
                    } else if (event instanceof IBuildingEventDescription) {
                        IBuildingEventDescription buildEvent = (IBuildingEventDescription)event;
                        nameLabel.setText(MessageUtils.format(buildEvent.getBuildingName(), new Object[0]).append(" " + buildEvent.getLevel(), new Object[0]).create());
                    }
                    ((Text)rowPane.findPaneOfTypeByID("pos", Text.class)).setText(event.getEventPos().func_177958_n() + " " + event.getEventPos().func_177956_o() + " " + event.getEventPos().func_177952_p());
                    ((Button)rowPane.findPaneOfTypeByID("addfakeplayer", Button.class)).hide();
                }
            }
        });
    }

    private void addPlayerToColonyClicked(@NotNull Button button) {
        int row = this.eventList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < ((ITownHallView)this.building).getPermissionEvents().size()) {
            PermissionEvent user = ((ITownHallView)this.building).getPermissionEvents().get(row);
            Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayerOrFakePlayer(((ITownHallView)this.building).getColony(), user.getName(), user.getId()));
        }
    }

    public void permissionEventsClicked(@NotNull Button button) {
        this.permissionEvents = !this.permissionEvents;
        button.setText((IFormattableTextComponent)new TranslationTextComponent(this.permissionEvents ? "com.minecolonies.coremod.gui.townhall.colonyevents" : "com.minecolonies.coremod.gui.townhall.permissionevents"));
    }

    @Override
    protected String getWindowId() {
        return "infopage";
    }
}

