/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.WindowResearchTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class UniversityModuleWindow
extends AbstractModuleWindow {
    public UniversityModuleWindow(IBuildingView building) {
        super(building, "minecolonies:gui/layouthuts/layoutuniversity.xml");
        List<ResourceLocation> inputBranches = IGlobalResearchTree.getInstance().getBranches();
        inputBranches.sort(Comparator.comparingInt(branchId -> IGlobalResearchTree.getInstance().getBranchData((ResourceLocation)branchId).getSortOrder()));
        ArrayList<ResourceLocation> visibleBranches = new ArrayList<ResourceLocation>();
        ArrayList<List<IFormattableTextComponent>> allReqs = new ArrayList<List<IFormattableTextComponent>>();
        for (ResourceLocation branch : inputBranches) {
            List<IFormattableTextComponent> requirements = this.getHidingRequirementDesc(branch);
            if (!requirements.isEmpty() && IGlobalResearchTree.getInstance().getBranchData(branch).getHidden()) continue;
            visibleBranches.add(branch);
            allReqs.add(requirements);
        }
        ScrollingList researchList = (ScrollingList)this.findPaneOfTypeByID("researches", ScrollingList.class);
        researchList.setDataProvider((ScrollingList.DataProvider)new ResearchListProvider(visibleBranches, allReqs));
        this.updateResearchCount(0);
    }

    public List<IFormattableTextComponent> getHidingRequirementDesc(ResourceLocation branch) {
        ArrayList<IFormattableTextComponent> requirements = new ArrayList<IFormattableTextComponent>();
        for (ResourceLocation primary : IGlobalResearchTree.getInstance().getPrimaryResearch(branch)) {
            if (!IGlobalResearchTree.getInstance().getResearch(branch, primary).isHidden() || IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(IGlobalResearchTree.getInstance().getResearch(branch, primary).getResearchRequirement(), this.buildingView.getColony())) {
                return Collections.EMPTY_LIST;
            }
            if (requirements.isEmpty()) {
                requirements.add((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.locked"));
            } else {
                requirements.add(new TranslationTextComponent("Or").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE)));
            }
            for (IResearchRequirement req : IGlobalResearchTree.getInstance().getResearch(branch, primary).getResearchRequirement()) {
                if (!req.isFulfilled(this.buildingView.getColony())) {
                    requirements.add(new StringTextComponent("-").func_230529_a_((ITextComponent)req.getDesc().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED))));
                    continue;
                }
                requirements.add(new StringTextComponent("-").func_230529_a_((ITextComponent)req.getDesc().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA))));
            }
        }
        return requirements;
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (button.getParent() != null && ResourceLocation.func_217855_b((String)button.getParent().getID()) && IGlobalResearchTree.getInstance().getBranches().contains(new ResourceLocation(button.getParent().getID()))) {
            new WindowResearchTree(new ResourceLocation(button.getParent().getID()), this.buildingView, this).open();
        }
    }

    public void updateResearchCount(int offset) {
        ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.research.countinprogress", new Object[]{this.buildingView.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() + offset, this.buildingView.getBuildingLevel()}));
        if (this.buildingView.getBuildingLevel() <= this.buildingView.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() + offset) {
            ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setColors(Color.getByName((String)"red", (int)0));
        } else {
            ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setColors(Color.getByName((String)"black", (int)0));
        }
    }

    private static class ResearchListProvider
    implements ScrollingList.DataProvider {
        private final List<ResourceLocation> branches;
        private final List<List<IFormattableTextComponent>> requirements;

        ResearchListProvider(List<ResourceLocation> branches, List<List<IFormattableTextComponent>> requirements) {
            this.branches = branches;
            this.requirements = requirements;
        }

        public int getElementCount() {
            return this.branches.size();
        }

        public void updateElement(int index, Pane rowPane) {
            ButtonImage button = (ButtonImage)rowPane.findPaneOfTypeByID("name", ButtonImage.class);
            button.getParent().setID(this.branches.get(index).toString());
            if (this.requirements.get(index).isEmpty()) {
                button.setText((IFormattableTextComponent)IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getName());
            } else {
                button.setText((IFormattableTextComponent)new TranslationTextComponent("----------"));
                button.disable();
            }
            if (!(button.getHoverPane() != null || this.requirements.get(index).isEmpty() && IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getSubtitle().func_150268_i().isEmpty())) {
                AbstractTextBuilder.TooltipBuilder hoverText = PaneBuilders.tooltipBuilder().hoverPane((Pane)button);
                if (!IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getSubtitle().func_150268_i().isEmpty()) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverText.append((IFormattableTextComponent)IGlobalResearchTree.getInstance().getBranchData(this.branches.get(index)).getSubtitle())).colorName("GRAY")).paragraphBreak();
                }
                if (!this.requirements.get(index).isEmpty()) {
                    for (IFormattableTextComponent req : this.requirements.get(index)) {
                        ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverText.append(req)).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).paragraphBreak();
                    }
                }
                hoverText.build();
            }
        }
    }
}

