/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.FarmerFieldModuleView;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class FarmerFieldsModuleWindow
extends AbstractModuleWindow {
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_FARMER_RESOURCE_SUFFIX = ":gui/layouthuts/layoutfarmerfields.xml";
    private static final String PAGE_FIELDS = "pageFields";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_WORKER = "worker";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private static final String TAG_BUTTON_ASSIGN = "assignFarm";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private static final String TAG_ICON = "icon";
    private final FarmerFieldModuleView moduleView;
    private List<BlockPos> fields = new ArrayList<BlockPos>();
    private ScrollingList fieldList;
    private final ClientWorld world;

    public FarmerFieldsModuleWindow(IBuildingView building, FarmerFieldModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutfarmerfields.xml");
        this.world = Minecraft.func_71410_x().field_71441_e;
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
        this.moduleView = moduleView;
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane((Pane)button);
        BlockPos field = this.fields.get(row);
        TileEntity entity = this.world.func_175625_s(field);
        if (entity instanceof ScarecrowTileEntity) {
            if (button.getTextAsString().equals(RED_X)) {
                button.setText(APPROVE);
                this.moduleView.changeFields(field, false, (ScarecrowTileEntity)entity);
            } else {
                button.setText(RED_X);
                this.moduleView.changeFields(field, true, (ScarecrowTileEntity)entity);
            }
            this.pullLevelsFromHut();
            ((ScrollingList)this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class)).refreshElementPanes();
        }
    }

    private void pullLevelsFromHut() {
        this.fields = this.moduleView.getFields();
    }

    private void assignmentModeClicked(@NotNull Button button) {
        String buttonText;
        String string = buttonText = button.getText() instanceof TranslationTextComponent ? ((TranslationTextComponent)button.getText()).func_150268_i() : button.getTextAsString();
        if (buttonText.equals("com.minecolonies.coremod.gui.hiring.off")) {
            button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.on"));
            this.moduleView.setAssignFieldManually(true);
        } else {
            button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.off"));
            this.moduleView.setAssignFieldManually(false);
        }
        ((ScrollingList)this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class)).refreshElementPanes();
    }

    public void onOpened() {
        super.onOpened();
        if (this.moduleView.assignFieldManually()) {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.on"){});
        } else {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.hiring.off"));
        }
        this.fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FarmerFieldsModuleWindow.this.fields.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                BlockPos field = (BlockPos)FarmerFieldsModuleWindow.this.fields.get(index);
                @NotNull String distance = Integer.toString((int)Math.sqrt(BlockPosUtil.getDistanceSquared(field, FarmerFieldsModuleWindow.this.buildingView.getPosition())));
                ITextComponent direction = BlockPosUtil.calcDirection(FarmerFieldsModuleWindow.this.buildingView.getPosition(), field);
                TileEntity entity = FarmerFieldsModuleWindow.this.world.func_175625_s(field);
                if (entity instanceof ScarecrowTileEntity) {
                    ScarecrowTileEntity scarecrowTileEntity = (ScarecrowTileEntity)entity;
                    @NotNull StringTextComponent owner = scarecrowTileEntity.getOwner().isEmpty() ? new StringTextComponent("<").func_230529_a_((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.farmerhut.unused")).func_240702_b_(">") : new StringTextComponent(scarecrowTileEntity.getOwner());
                    ((Text)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_WORKER, Text.class)).setText((ITextComponent)owner);
                    ((Text)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_DISTANCE, Text.class)).setText(distance + "m");
                    ((Text)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_DIRECTION, Text.class)).setText(direction);
                    Button assignButton = (Button)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_BUTTON_ASSIGN, Button.class);
                    assignButton.setEnabled(FarmerFieldsModuleWindow.this.moduleView.assignFieldManually());
                    if (((ScarecrowTileEntity)entity).isTaken()) {
                        assignButton.setText(FarmerFieldsModuleWindow.RED_X);
                    } else {
                        assignButton.setText(FarmerFieldsModuleWindow.APPROVE);
                        if (FarmerFieldsModuleWindow.this.buildingView.getBuildingLevel() <= FarmerFieldsModuleWindow.this.moduleView.getAmountOfFields()) {
                            assignButton.disable();
                        }
                    }
                    if (((ScarecrowTileEntity)entity).getSeed() != null) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(FarmerFieldsModuleWindow.TAG_ICON, ItemIcon.class)).setItem(((ScarecrowTileEntity)entity).getSeed());
                    }
                }
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullLevelsFromHut();
    }
}

