/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.citizen;

import com.ldtteam.blockout.PaneBuilders;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowRequestTree;
import com.minecolonies.coremod.client.gui.citizen.FamilyWindowCitizen;
import com.minecolonies.coremod.client.gui.citizen.HappinessWindowCitizen;
import com.minecolonies.coremod.client.gui.citizen.JobWindowCitizen;
import com.minecolonies.coremod.client.gui.citizen.MainWindowCitizen;
import com.minecolonies.coremod.client.gui.citizen.RequestWindowCitizen;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AbstractWindowCitizen
extends AbstractWindowRequestTree {
    public AbstractWindowCitizen(ICitizenDataView citizen, String ui) {
        super(citizen.getWorkBuilding(), ui, IColonyManager.getInstance().getColonyView(citizen.getColonyId(), (RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_()));
        this.registerButton("mainTab", () -> new MainWindowCitizen(citizen).open());
        this.registerButton("mainIcon", () -> new MainWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("mainIcon")).build().setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.main"));
        this.registerButton("requestTab", () -> new RequestWindowCitizen(citizen).open());
        this.registerButton("requestIcon", () -> new RequestWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("requestIcon")).build().setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.requests"));
        this.registerButton("inventoryTab", () -> Network.getNetwork().sendToServer(new OpenInventoryMessage(this.colony, citizen.getName(), citizen.getEntityId())));
        this.registerButton("inventoryIcon", () -> Network.getNetwork().sendToServer(new OpenInventoryMessage(this.colony, citizen.getName(), citizen.getEntityId())));
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("inventoryIcon")).build().setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.inventory"));
        this.registerButton("happinessTab", () -> new HappinessWindowCitizen(citizen).open());
        this.registerButton("happinessIcon", () -> new HappinessWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("happinessIcon")).build().setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.happiness"));
        this.registerButton("familyTab", () -> new FamilyWindowCitizen(citizen).open());
        this.registerButton("familyIcon", () -> new FamilyWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("familyIcon")).build().setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.family"));
        IBuildingView building = this.colony.getBuilding(citizen.getWorkBuilding());
        if (building instanceof AbstractBuildingView && building.getBuildingType() != ModBuildings.library) {
            this.findPaneByID("jobTab").setVisible(true);
            this.findPaneByID("jobIcon").setVisible(true);
            this.registerButton("jobTab", () -> new JobWindowCitizen(citizen).open());
            this.registerButton("jobIcon", () -> new JobWindowCitizen(citizen).open());
            PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("jobIcon")).build().setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.job"));
        } else {
            this.findPaneByID("jobTab").setVisible(false);
            this.findPaneByID("jobIcon").setVisible(false);
        }
    }
}

