/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.event.HighlightManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowHutAllInventory
extends AbstractWindowSkeleton {
    List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private final ScrollingList stackList;
    private String filter = "";
    private int sortDescriptor = 0;
    private final IBuildingView building;
    private final Window prev;
    private int tick;

    public WindowHutAllInventory(IBuildingView b, Window prev) {
        super("minecolonies:gui/windowhutallinventory.xml");
        this.building = b;
        this.registerButton("sortStorageFilter", this::setSortFlag);
        this.registerButton("back", this::back);
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("allinventorylist", ScrollingList.class);
        this.updateResources();
        this.registerButton("locate", this::locate);
        this.prev = prev;
        ((TextField)this.window.findPaneOfTypeByID("names", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private void locate(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStorage storage = this.allItems.get(row);
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.building.getContainerList());
        containerList.add(this.building.getID());
        HighlightManager.clearCategory("inventoryHighlight");
        MessageUtils.format("com.minecolonies.coremod.locating", new Object[0]).sendTo(new PlayerEntity[]{Minecraft.func_71410_x().field_71439_g});
        this.close();
        for (BlockPos blockPos : containerList) {
            int count;
            TileEntity rack = Minecraft.func_71410_x().field_71441_e.func_175625_s(blockPos);
            if (!(rack instanceof TileEntityRack) || (count = ((TileEntityRack)rack).getCount(storage.getItemStack(), storage.ignoreDamageValue(), false)) <= 0) continue;
            int color = 65280 + 0xFF0000 * Math.max(0, 1 - count / 64);
            HighlightManager.addRenderBox("inventoryHighlight", new HighlightManager.TimedBoxRenderData().setPos(blockPos).setRemovalTimePoint(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 1200L).addText("" + count).setColor(color));
        }
    }

    private void back() {
        this.close();
        this.prev.open();
    }

    private void setSortFlag() {
        ++this.sortDescriptor;
        if (this.sortDescriptor > 4) {
            this.sortDescriptor = 0;
        }
        switch (this.sortDescriptor) {
            case 0: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText("v^");
                break;
            }
            case 1: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText("A^");
                break;
            }
            case 2: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText("Av");
                break;
            }
            case 3: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText("1^");
                break;
            }
            case 4: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText("1v");
                break;
            }
        }
        this.updateResources();
    }

    private void updateResources() {
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.building.getContainerList());
        HashMap<ItemStorage, Integer> storedItems = new HashMap<ItemStorage, Integer>();
        World world = this.building.getColony().getWorld();
        containerList.add(this.building.getPosition());
        for (BlockPos blockPos : containerList) {
            TileEntity rack = world.func_175625_s(blockPos);
            if (!(rack instanceof TileEntityRack)) continue;
            Map<ItemStorage, Integer> rackStorage = ((TileEntityRack)rack).getAllContent();
            for (Map.Entry<ItemStorage, Integer> entry : rackStorage.entrySet()) {
                if (storedItems.containsKey(entry.getKey())) {
                    storedItems.put(entry.getKey(), (Integer)storedItems.get(entry.getKey()) + entry.getValue());
                    continue;
                }
                storedItems.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList filterItems = new ArrayList();
        storedItems.forEach((storage, amount) -> {
            storage.setAmount((int)amount);
            filterItems.add(storage);
        });
        Predicate<ItemStorage> filterPredicate = stack -> this.filter.isEmpty() || stack.getItemStack().func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || WindowHutAllInventory.getString(stack.getItemStack()).toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        if (this.filter.isEmpty()) {
            this.allItems.addAll(filterItems);
        } else {
            this.allItems.addAll(filterItems.stream().filter(filterPredicate).collect(Collectors.toList()));
        }
        this.allItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.getItemStack().func_200301_q().getString(), (CharSequence)this.filter)));
        Comparator<ItemStorage> compareByName = Comparator.comparing(o -> o.getItemStack().func_200301_q().getString());
        Comparator<ItemStorage> compareByCount = Comparator.comparingInt(ItemStorage::getAmount);
        switch (this.sortDescriptor) {
            case 0: {
                break;
            }
            case 1: {
                this.allItems.sort(compareByName);
                break;
            }
            case 2: {
                this.allItems.sort(compareByName.reversed());
                break;
            }
            case 3: {
                this.allItems.sort(compareByCount);
                break;
            }
            case 4: {
                this.allItems.sort(compareByCount.reversed());
                break;
            }
        }
        this.updateResourceList();
    }

    private static String getString(ItemStack stack) {
        StringBuilder output = new StringBuilder();
        for (ITextComponent comp : stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL)) {
            output.append(comp.getString()).append(" ");
        }
        return output.toString();
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutAllInventory.this.allItems.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = WindowHutAllInventory.this.allItems.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("ressourceStackName", Text.class);
                String name = resource.getItemStack().func_200301_q().getString();
                resourceLabel.setText(name.substring(0, Math.min(17, name.length())));
                Text qtys = (Text)rowPane.findPaneOfTypeByID("quantities", Text.class);
                if (!Screen.func_231173_s_()) {
                    qtys.setText(Utils.format(resource.getAmount()));
                } else {
                    qtys.setText(Integer.toString(resource.getAmount()));
                }
                Item imagesrc = resource.getItemStack().func_77973_b();
                ItemStack image = new ItemStack((IItemProvider)imagesrc, 1);
                image.func_77982_d(resource.getItemStack().func_77978_p());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(image);
            }
        });
    }
}

