/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.network.messages.server.RemoveFromRallyingListMessage;
import com.minecolonies.coremod.network.messages.server.ToggleBannerRallyGuardsMessage;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class WindowBannerRallyGuards
extends AbstractWindowSkeleton {
    private static final String BUILD_TOOL_RESOURCE_SUFFIX = ":gui/windowbannerrallyguards.xml";
    private static final String LIST_GUARDTOWERS = "guardtowers";
    private static final String ICON_GUARD = "guardicon";
    private static final String BUTTON_REMOVE = "remove";
    private static final String BUTTON_RALLY = "rally";
    private static final String LABEL_GUARDTYPE = "guardtype";
    private static final String LABEL_POSITION = "position";
    private ScrollingList guardTowerList;
    private ItemStack banner = null;

    public WindowBannerRallyGuards(ItemStack banner) {
        super("minecolonies:gui/windowbannerrallyguards.xml");
        this.banner = banner;
        this.registerButton(BUTTON_REMOVE, this::removeClicked);
        this.registerButton(BUTTON_RALLY, this::rallyClicked);
    }

    public void onOpened() {
        this.guardTowerList = (ScrollingList)this.findPaneOfTypeByID(LIST_GUARDTOWERS, ScrollingList.class);
        if (ItemBannerRallyGuards.isActive(this.banner)) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_RALLY, ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.item.bannerrallyguards.gui.dismiss"));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_RALLY, ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.item.bannerrallyguards.gui.rally"));
        }
        this.guardTowerList.setDataProvider(() -> ItemBannerRallyGuards.getGuardTowerViews(this.banner).size(), (index, rowPane) -> {
            List<Pair<ILocation, AbstractBuildingGuards.View>> guardTowers = ItemBannerRallyGuards.getGuardTowerViews(this.banner);
            if (index < 0 || index >= guardTowers.size()) {
                return;
            }
            Pair<ILocation, AbstractBuildingGuards.View> guardTower = guardTowers.get(index);
            ItemIcon exampleStackDisplay = (ItemIcon)rowPane.findPaneOfTypeByID(ICON_GUARD, ItemIcon.class);
            AbstractBuildingGuards.View guardTowerView = (AbstractBuildingGuards.View)guardTower.getSecond();
            if (guardTowerView != null) {
                exampleStackDisplay.setItem(new ItemStack((IItemProvider)Items.field_151040_l));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_GUARDTYPE, Text.class)).setText(new TranslationTextComponent(ModGuardTypes.knight.getJobTranslationKey()).func_240702_b_("|").func_230529_a_((ITextComponent)new TranslationTextComponent(ModGuardTypes.ranger.getJobTranslationKey())).func_240702_b_(": ").func_240702_b_(String.valueOf(guardTowerView.getGuards().size())));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_POSITION, Text.class)).setText((IFormattableTextComponent)new StringTextComponent(((ILocation)guardTower.getFirst()).toString()));
            } else {
                exampleStackDisplay.setItem(new ItemStack((IItemProvider)Items.field_151106_aX));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_GUARDTYPE, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.item.bannerrallyguards.gui.towermissing"));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_GUARDTYPE, Text.class)).setColors(Color.rgbaToInt((int)255, (int)0, (int)0, (int)1));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_POSITION, Text.class)).setText(((ILocation)guardTower.getFirst()).toString());
            }
        });
    }

    private void removeClicked(@NotNull Button button) {
        int row = this.guardTowerList.getListElementIndexByPane((Pane)button);
        List<Pair<ILocation, AbstractBuildingGuards.View>> guardTowers = ItemBannerRallyGuards.getGuardTowerViews(this.banner);
        if (guardTowers.size() > row && row >= 0) {
            ILocation locationToRemove = (ILocation)guardTowers.get(row).getFirst();
            Network.getNetwork().sendToServer(new RemoveFromRallyingListMessage(this.banner, locationToRemove));
            ItemBannerRallyGuards.removeGuardTowerAtLocation(this.banner, locationToRemove);
        }
    }

    private void rallyClicked(@NotNull Button button) {
        Network.getNetwork().sendToServer(new ToggleBannerRallyGuardsMessage(this.banner));
        this.close();
    }
}

