/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowModuleBuilding;
import com.minecolonies.coremod.client.gui.WindowHireWorker;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.network.messages.server.colony.building.ChangeDeliveryPriorityMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.ForcePickupMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.RecallCitizenMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowWorkerModuleBuilding<B extends IBuildingView>
extends AbstractWindowModuleBuilding<B> {
    private static final String BUTTON_HIRE = "hire";
    private static final String LIST_WORKERS = "workers";
    private static final String BUTTON_RECALL = "recall";
    private static final String LABEL_PRIO_VALUE = "prioValue";
    private static final String LABEL_WORKERNAME = "workerName";
    private static final String BUTTON_DP_UP = "deliveryPrioUp";
    private static final String BUTTON_DP_DOWN = "deliveryPrioDown";
    private static final String BUTTON_FORCE_PICKUP = "forcePickup";
    private int prio;

    protected AbstractWindowWorkerModuleBuilding(B building, String resource) {
        super(building, resource);
        this.prio = this.building.getBuildingDmPrio();
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton(BUTTON_RECALL, this::recallClicked);
        super.registerButton(BUTTON_DP_UP, this::deliveryPriorityUp);
        super.registerButton(BUTTON_DP_DOWN, this::deliveryPriorityDown);
        super.registerButton(BUTTON_FORCE_PICKUP, this::forcePickup);
    }

    private void updatePriorityLabel() {
        IFormattableTextComponent component = this.prio == 0 ? new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.buildprio").func_230529_a_((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.deliveryprio.never")) : new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.buildprio").func_230529_a_((ITextComponent)new StringTextComponent(this.prio + "/10"));
        ((Text)this.findPaneOfTypeByID(LABEL_PRIO_VALUE, Text.class)).setText((ITextComponent)component);
    }

    private void deliveryPriorityUp() {
        if (this.prio != 10) {
            ++this.prio;
        }
        Network.getNetwork().sendToServer(new ChangeDeliveryPriorityMessage(this.building, true));
        this.updatePriorityLabel();
    }

    private void deliveryPriorityDown() {
        if (this.prio != 0) {
            --this.prio;
        }
        Network.getNetwork().sendToServer(new ChangeDeliveryPriorityMessage(this.building, false));
        this.updatePriorityLabel();
    }

    private void forcePickup() {
        Network.getNetwork().sendToServer(new ForcePickupMessage(this.building));
    }

    protected void hireClicked(@NotNull Button button) {
        if (this.building.getBuildingLevel() == 0 && !((Object)((Object)ModBuildings.builder)).equals((Object)this.building.getBuildingType())) {
            MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.level0", new Object[0]).sendTo(new PlayerEntity[]{Minecraft.func_71410_x().field_71439_g});
            return;
        }
        @NotNull WindowHireWorker window = new WindowHireWorker(this.building.getColony(), this.building.getPosition());
        window.open();
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallCitizenMessage(this.building));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        final ArrayList<Tuple<String, Integer>> workers = new ArrayList<Tuple<String, Integer>>();
        for (WorkerBuildingModuleView module : this.buildingView.getModuleViews(WorkerBuildingModuleView.class)) {
            for (int worker : module.getAssignedCitizens()) {
                workers.add(new Tuple<String, Integer>(new TranslationTextComponent(module.getJobEntry().getTranslationKey()).getString(), worker));
            }
        }
        if (this.findPaneByID(LIST_WORKERS) != null) {
            ScrollingList workerList = (ScrollingList)this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
            workerList.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return workers.size();
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    ICitizenDataView worker = AbstractWindowWorkerModuleBuilding.this.building.getColony().getCitizen((Integer)((Tuple)workers.get(index)).getB());
                    if (worker != null) {
                        ((Text)rowPane.findPaneOfTypeByID(AbstractWindowWorkerModuleBuilding.LABEL_WORKERNAME, Text.class)).setText(new TranslationTextComponent((String)((Tuple)workers.get(index)).getA()).getString() + ": " + worker.getName());
                    }
                }
            });
        }
        this.updatePriorityLabel();
    }
}

