/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesHorizontal;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockDecorationController
extends AbstractBlockMinecoloniesHorizontal<BlockDecorationController>
implements IBuilderUndestroyable,
IAnchorBlock {
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "decorationcontroller";
    private static final float RESISTANCE = 1.0f;
    public static BooleanProperty MIRROR = BooleanProperty.func_177716_a((String)"mirror");
    protected static final VoxelShape AABB_SOUTH = VoxelShapes.func_197873_a((double)0.25, (double)0.314, (double)0.97, (double)0.75, (double)0.86, (double)1.0);
    protected static final VoxelShape AABB_NORTH = VoxelShapes.func_197873_a((double)0.25, (double)0.314, (double)0.0, (double)0.75, (double)0.86, (double)0.3);
    protected static final VoxelShape AABB_EAST = VoxelShapes.func_197873_a((double)0.97, (double)0.314, (double)0.25, (double)1.0, (double)0.86, (double)0.75);
    protected static final VoxelShape AABB_WEST = VoxelShapes.func_197873_a((double)0.0, (double)0.314, (double)0.25, (double)0.3, (double)0.86, (double)0.75);

    public BlockDecorationController() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(5.0f, 1.0f).func_200942_a());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)MIRROR, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName(BLOCK_NAME);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction Direction2 = (Direction)state.func_177229_b((Property)field_185512_D);
        switch (Direction2) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
        }
        return AABB_NORTH;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity tileEntity;
        if (worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityDecorationController) {
            MineColonies.proxy.openDecorationControllerWindow(pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        IColony colony;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDecorationController && ((List)((TileEntityDecorationController)tileEntity).getPositionedTags().getOrDefault(BlockPos.field_177992_a, new ArrayList())).contains("leisure") && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null) {
            colony.getBuildingManager().addLeisureSite(pos);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, MIRROR});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityDecorationController();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f());
    }

    @NotNull
    public BlockState func_185499_a(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }

    @NotNull
    public BlockState func_185471_a(@NotNull BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)MIRROR, (Comparable)Boolean.valueOf(mirrorIn != Mirror.NONE));
    }
}

