/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.util.Tuple;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.event.world.NoteBlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoundUtils {
    private static final int ONE_HUNDRED = 100;
    public static final double PITCH = 0.9;
    private static final Random rand = new Random();
    public static final double VOLUME = 0.5;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    public static final NoteBlockEvent.Note[] PENTATONIC = new NoteBlockEvent.Note[]{NoteBlockEvent.Note.A, NoteBlockEvent.Note.B, NoteBlockEvent.Note.D, NoteBlockEvent.Note.E, NoteBlockEvent.Note.F_SHARP, NoteBlockEvent.Note.A, NoteBlockEvent.Note.B, NoteBlockEvent.Note.D};
    private static final double MIN_REQUIRED_SOUND_DIST = 100.0;

    private SoundUtils() {
    }

    public static void playRandomSound(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull ICitizenData citizen) {
        boolean playerCloseEnough = false;
        for (PlayerEntity playerEntity : citizen.getColony().getPackageManager().getCloseSubscribers()) {
            if (!(playerEntity.func_233580_cy_().func_177951_i((Vector3i)pos) < 100.0)) continue;
            playerCloseEnough = true;
            break;
        }
        if (!playerCloseEnough) {
            return;
        }
        double v = rand.nextDouble();
        if (v <= 0.1) {
            if (citizen.getSaturation() < 2.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_LOW, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SATURATION_HIGH, citizen);
            }
        } else if (v <= 0.2) {
            if (citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony()) < 5.0) {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.UNHAPPY, citizen);
            } else {
                SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.HAPPY, citizen);
            }
        } else if (v <= 0.3) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.GENERAL, citizen);
        } else if (v <= 0.4 && citizen.getEntity().isPresent() && citizen.getEntity().get().getCitizenDiseaseHandler().isSick()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.SICKNESS, citizen);
        } else if (v <= 0.5 && (citizen.getHomeBuilding() == null || citizen.getHomeBuilding().getBuildingLevel() <= 2)) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_HOUSING, citizen);
        } else if (v <= 0.6 && worldIn.func_72896_J()) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.BAD_WEATHER, citizen);
        } else if (v <= 1.0) {
            SoundUtils.playSoundAtCitizenWith(worldIn, pos, EventType.NOISE, citizen);
        }
    }

    public static void playSoundAtCitizen(@NotNull World worldIn, @NotNull BlockPos position, @NotNull SoundEvent event) {
        worldIn.func_184133_a(null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
    }

    public static void playSuccessSound(@NotNull PlayerEntity player, @NotNull BlockPos position) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(SoundEvents.field_193807_ew, SoundCategory.NEUTRAL, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 1.0f, 1.0f));
        }
    }

    public static void playErrorSound(@NotNull PlayerEntity player, @NotNull BlockPos position) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(SoundEvents.field_219663_hb, SoundCategory.NEUTRAL, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 1.0f, 0.3f));
        }
    }

    public static void playSoundAtCitizenWith(@NotNull World worldIn, @NotNull BlockPos position, @Nullable EventType type, @Nullable ICitizenData citizenData) {
        SoundEvent event;
        if (citizenData == null) {
            return;
        }
        Map<EventType, Tuple<SoundEvent, SoundEvent>> map = citizenData.getJob() != null ? ModSoundEvents.CITIZEN_SOUND_EVENTS.get(citizenData.getJob().getJobRegistryEntry().getRegistryName().func_110623_a()) : ModSoundEvents.CITIZEN_SOUND_EVENTS.get(citizenData.isChild() ? "child" : "citizen");
        SoundEvent soundEvent = event = citizenData.isFemale() ? map.get((Object)type).getB() : map.get((Object)type).getA();
        if (type.getChance() > rand.nextDouble() * 100.0) {
            worldIn.func_184133_a(null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
        }
    }

    public static void playSoundAtCivilian(@NotNull World worldIn, @NotNull BlockPos position, @Nullable EventType type, @Nullable ICivilianData civilianData) {
        SoundEvent event;
        if (civilianData == null) {
            return;
        }
        Map<EventType, Tuple<SoundEvent, SoundEvent>> map = ModSoundEvents.CITIZEN_SOUND_EVENTS.get(civilianData.isChild() ? "child" : "citizen");
        SoundEvent soundEvent = event = civilianData.isFemale() ? map.get((Object)type).getB() : map.get((Object)type).getA();
        if (type.getChance() > rand.nextDouble() * 100.0) {
            worldIn.func_184133_a(null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
        }
    }

    public static double getRandomPitch(Random random) {
        return 1.0 / (random.nextDouble() * 0.4 + 0.8);
    }

    public static double getRandomPentatonic(Random random) {
        int index = random.nextInt(PENTATONIC.length);
        int tone = PENTATONIC[index].ordinal() + Math.floorDiv(index, 5) * 12;
        return Math.pow(2.0, (double)(tone - 12) / 12.0);
    }

    public static void playSoundForPlayer(ServerPlayerEntity playerEntity, SoundEvent sound, float volume, float pitch) {
        playerEntity.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(sound, playerEntity.func_184176_by(), playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), 16.0f * volume, pitch));
    }
}

