/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import org.jetbrains.annotations.NotNull;

public class BlockStateStorage {
    private final BlockState state;
    private final List<Property<?>> propertyList;
    private int hashCode;
    private final boolean exclude;

    public BlockStateStorage(@NotNull BlockState state, @NotNull List<Property<?>> compareProperties, boolean exclude) {
        this.state = state;
        this.propertyList = compareProperties;
        this.exclude = exclude;
        this.hashCode = state.func_177230_c().hashCode();
        if (!exclude) {
            for (Property<?> prop : compareProperties) {
                if (!state.func_235901_b_(prop)) continue;
                this.hashCode += prop.hashCode();
                this.hashCode += state.func_177229_b(prop).hashCode();
            }
        } else {
            for (Property prop : state.func_235904_r_()) {
                if (compareProperties.contains(prop)) continue;
                this.hashCode += prop.hashCode();
                this.hashCode += state.func_177229_b(prop).hashCode();
            }
        }
    }

    public BlockState getState() {
        return this.state;
    }

    public List<Property<?>> getCompareProperties() {
        return this.propertyList;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStateStorage comparingToStorage = (BlockStateStorage)o;
        if (comparingToStorage.getState() == this.state) {
            return true;
        }
        if (this.exclude) {
            for (Property prop : this.state.func_235904_r_()) {
                if (this.getCompareProperties().contains(prop)) continue;
                if (!comparingToStorage.getState().func_235901_b_(prop)) {
                    return false;
                }
                if (comparingToStorage.getState().func_177229_b(prop).equals(this.state.func_177229_b(prop))) continue;
                return false;
            }
        } else {
            for (Property<?> prop : this.propertyList) {
                if (!comparingToStorage.getState().func_235901_b_(prop)) {
                    return false;
                }
                if (comparingToStorage.getState().func_177229_b(prop).equals(this.state.func_177229_b(prop))) continue;
                return false;
            }
        }
        return true;
    }
}

