/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerRack;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends AbstractTileEntityRack {
    private static final byte VERSION = 2;
    private byte version = 0;
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private int size = 0;
    private int freeSlots = 0;
    private LazyOptional<IItemHandler> lastOptional;

    public TileEntityRack(TileEntityType<? extends TileEntityRack> type) {
        super(type);
    }

    public TileEntityRack() {
        super(MinecoloniesTileEntities.RACK);
    }

    @Override
    public void setInWarehouse(Boolean isInWarehouse) {
        this.inWarehouse = isInWarehouse;
    }

    @Override
    public int getFreeSlots() {
        return this.freeSlots;
    }

    @Override
    public boolean hasItemStack(ItemStack stack, int count, boolean ignoreDamageValue) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue);
        return this.content.getOrDefault(checkItem, 0) >= count;
    }

    @Override
    public int getCount(ItemStack stack, boolean ignoreDamageValue, boolean ignoreNBT) {
        ItemStorage checkItem = new ItemStorage(stack, ignoreDamageValue, ignoreNBT);
        return this.getCount(checkItem);
    }

    @Override
    public int getCount(ItemStorage storage) {
        if (storage.ignoreDamageValue() || storage.ignoreNBT()) {
            if (!this.content.containsKey(storage)) {
                return 0;
            }
            int count = 0;
            for (Map.Entry<ItemStorage, Integer> contentStorage : this.content.entrySet()) {
                if (!contentStorage.getKey().equals(storage)) continue;
                count += contentStorage.getValue().intValue();
            }
            return count;
        }
        return this.content.getOrDefault(storage, 0);
    }

    @Override
    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSimilarStack(@NotNull ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack, true, true);
        if (this.content.containsKey(checkItem)) {
            return true;
        }
        for (ItemStorage storage : this.content.keySet()) {
            if (checkItem.getPrimaryCreativeTabIndex() != storage.getPrimaryCreativeTabIndex()) continue;
            return true;
        }
        return false;
    }

    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void upgradeRackSize() {
        ++this.size;
        AbstractTileEntityRack.RackInventory tempInventory = new AbstractTileEntityRack.RackInventory(27 + this.size * 9);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.invalidateCap();
    }

    @Override
    public int getItemCount(Predicate<ItemStack> predicate) {
        int matched = 0;
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!predicate.test(entry.getKey().getItemStack())) continue;
            matched += entry.getValue().intValue();
        }
        return matched;
    }

    @Override
    public void updateItemStorage() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean empty = this.content.isEmpty();
            this.updateContent();
            if (empty && !this.content.isEmpty() || !empty && this.content.isEmpty()) {
                this.updateBlockState();
            }
            this.func_70296_d();
        }
    }

    private void updateContent() {
        this.content.clear();
        this.freeSlots = 0;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
                continue;
            }
            ItemStorage storage = new ItemStorage(stack.func_77946_l());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public void updateBlockState() {
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof AbstractBlockMinecoloniesRack) {
            if (!(this.main || this.single || this.getOtherChest() == null || this.getOtherChest().isMain())) {
                this.setMain(true);
            }
            if (this.main || this.single) {
                BlockState typeNeighbor;
                BlockState typeHere;
                if (this.content.isEmpty() && (this.getOtherChest() == null || this.getOtherChest().isEmpty())) {
                    if (this.getOtherChest() != null && this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor)).func_177230_c() instanceof AbstractBlockMinecoloniesRack) {
                        Direction dirToNeighbour = BlockPosUtil.getFacing(this.field_174879_c, this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor));
                        typeHere = (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR))).func_206870_a((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour);
                        typeNeighbor = (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor)).func_206870_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULTDOUBLE))).func_206870_a((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour.func_176734_d());
                    } else {
                        typeHere = (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULT));
                        typeNeighbor = null;
                    }
                } else if (this.getOtherChest() != null && this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor)).func_177230_c() instanceof AbstractBlockMinecoloniesRack) {
                    Direction dirToNeighbour = BlockPosUtil.getFacing(this.field_174879_c, this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor));
                    typeHere = (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR))).func_206870_a((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour);
                    typeNeighbor = (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor)).func_206870_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULLDOUBLE))).func_206870_a((Property)AbstractBlockMinecoloniesRack.FACING, (Comparable)dirToNeighbour.func_176734_d());
                } else {
                    typeHere = (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULL));
                    typeNeighbor = null;
                }
                if (this.isMain() && this.getOtherChest() != null && this.getOtherChest().isMain()) {
                    this.getOtherChest().setMain(false);
                }
                if (!this.field_145850_b.func_180495_p(this.field_174879_c).equals(typeHere)) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, typeHere);
                }
                if (typeNeighbor != null && !this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor)).equals(typeNeighbor)) {
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor), typeNeighbor);
                }
            } else {
                this.getOtherChest().updateBlockState();
            }
        }
    }

    @Override
    public AbstractTileEntityRack getOtherChest() {
        if (this.relativeNeighbor == null || this.field_145850_b == null) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor));
        if (tileEntity instanceof TileEntityRack && !(tileEntity instanceof AbstractTileEntityColonyBuilding)) {
            if (!this.func_174877_v().equals((Object)((TileEntityRack)tileEntity).getNeighbor())) {
                ((AbstractTileEntityRack)tileEntity).setNeighbor(this.func_174877_v());
            }
            return (AbstractTileEntityRack)tileEntity;
        }
        this.setSingle(true);
        this.relativeNeighbor = null;
        return null;
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(slots);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150296_c().contains("tagSIze")) {
            this.size = compound.func_74762_e("tagSIze");
            this.inventory = this.createInventory(27 + this.size * 9);
        }
        if (compound.func_150296_c().contains("relNeighbor")) {
            this.relativeNeighbor = BlockPosUtil.read(compound, "relNeighbor");
        }
        if (this.relativeNeighbor != null) {
            if (this.relativeNeighbor.func_177956_o() != 0) {
                this.relativeNeighbor = null;
            } else {
                this.setSingle(false);
            }
        }
        ListNBT inventoryTagList = compound.func_150295_c("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundNBT inventoryCompound = inventoryTagList.func_150305_b(i);
            if (inventoryCompound.func_74764_b("empty")) continue;
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)inventoryCompound);
            this.inventory.setStackInSlot(i, stack);
        }
        this.main = compound.func_74767_n("main");
        this.updateContent();
        this.inWarehouse = compound.func_74767_n("inWarehouse");
        if (compound.func_74764_b("pos")) {
            this.buildingPos = BlockPosUtil.read(compound, "pos");
        }
        this.version = compound.func_74771_c("version");
        this.invalidateCap();
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tagSIze", this.size);
        if (this.relativeNeighbor != null) {
            BlockPosUtil.write(compound, "relNeighbor", this.relativeNeighbor);
        }
        @NotNull ListNBT inventoryTagList = new ListNBT();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            @NotNull CompoundNBT inventoryCompound = new CompoundNBT();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.func_190926_b()) {
                inventoryCompound.func_74757_a("empty", true);
            } else {
                stack.func_77955_b(inventoryCompound);
            }
            inventoryTagList.add((Object)inventoryCompound);
        }
        compound.func_218657_a("inventory", (INBT)inventoryTagList);
        compound.func_74757_a("main", this.main);
        compound.func_74757_a("inWarehouse", this.inWarehouse);
        BlockPosUtil.write(compound, "pos", this.buildingPos);
        compound.func_74774_a("version", this.version);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(compound));
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void func_189667_a(Rotation rotationIn) {
        super.func_189667_a(rotationIn);
        if (this.relativeNeighbor != null) {
            this.relativeNeighbor = this.relativeNeighbor.func_190942_a(rotationIn);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction dir) {
        if (this.version != 2) {
            this.updateBlockState();
            this.version = (byte)2;
        }
        if (!this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.lastOptional != null && this.lastOptional.isPresent()) {
                return this.lastOptional.cast();
            }
            if (this.single) {
                this.lastOptional = LazyOptional.of(() -> {
                    if (this.func_145837_r()) {
                        return new AbstractTileEntityRack.RackInventory(0);
                    }
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
                });
                return this.lastOptional.cast();
            }
            this.lastOptional = LazyOptional.of(() -> {
                if (this.func_145837_r()) {
                    return new AbstractTileEntityRack.RackInventory(0);
                }
                AbstractTileEntityRack other = this.getOtherChest();
                if (other == null) {
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory());
                }
                if (this.main) {
                    return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", this.getInventory(), other.getInventory());
                }
                return new CombinedItemHandler("block.minecolonies.blockminecoloniesrack", other.getInventory(), this.getInventory());
            });
            return this.lastOptional.cast();
        }
        return super.getCapability(capability, dir);
    }

    @Override
    public BlockPos getNeighbor() {
        if (this.relativeNeighbor == null) {
            return null;
        }
        return this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor);
    }

    @Override
    public int getUpgradeSize() {
        return this.size;
    }

    @Override
    public boolean setNeighbor(BlockPos neighbor) {
        if (neighbor == null) {
            this.setSingle(true);
            this.relativeNeighbor = null;
            this.func_70296_d();
        } else if (this.field_174879_c.func_177973_b((Vector3i)neighbor).func_177956_o() == 0) {
            this.relativeNeighbor = this.field_174879_c.func_177973_b((Vector3i)neighbor);
            this.setSingle(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            WorldUtil.markChunkDirty(this.field_145850_b, this.field_174879_c);
        }
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        return new ContainerRack(id, inv, this.func_174877_v(), this.getOtherChest() == null ? BlockPos.field_177992_a : this.getOtherChest().func_174877_v());
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Rack");
    }

    @Override
    public void setMain(boolean main) {
        if (main != this.main) {
            this.invalidateCap();
            super.setMain(main);
        }
    }

    @Override
    public void setSingle(boolean single) {
        if (single != this.single) {
            this.invalidateCap();
            super.setSingle(single);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateCap();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.invalidateCap();
    }

    private void invalidateCap() {
        if (this.lastOptional != null && this.lastOptional.isPresent()) {
            this.lastOptional.invalidate();
        }
        this.lastOptional = null;
    }
}

