/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.minecolonies.api.inventory.ModContainers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ContainerCrafting
extends Container {
    public final CraftingInventory craftMatrix;
    public final CraftResultInventory craftResult = new CraftResultInventory();
    private final Slot craftResultSlot;
    private final List<ItemStack> remainingItems;
    private final boolean complete;
    private final World world;
    private final PlayerInventory inv;
    private final BlockPos pos;
    private final String moduleId;

    public static ContainerCrafting fromPacketBuffer(int windowId, PlayerInventory inv, PacketBuffer packetBuffer) {
        boolean complete = packetBuffer.readBoolean();
        BlockPos tePos = packetBuffer.func_179259_c();
        String moduleId = packetBuffer.func_150789_c(Short.MAX_VALUE);
        return new ContainerCrafting(windowId, inv, complete, tePos, moduleId);
    }

    public ContainerCrafting(int windowId, PlayerInventory inv, boolean complete, BlockPos pos, String moduleId) {
        super(ModContainers.craftingGrid, windowId);
        int j;
        int i;
        this.moduleId = moduleId;
        this.world = inv.field_70458_d.field_70170_p;
        this.inv = inv;
        this.complete = complete;
        this.pos = pos;
        this.craftMatrix = complete ? new CraftingInventory((Container)this, 3, 3) : new CraftingInventory((Container)this, 2, 2);
        this.craftResultSlot = this.func_75146_a((Slot)new CraftingResultSlot(inv.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35){

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        });
        for (i = 0; i < this.craftMatrix.func_174922_i(); ++i) {
            for (j = 0; j < this.craftMatrix.func_174923_h(); ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * (complete ? 3 : 2), 30 + j * 18, 17 + i * 18){

                    public int func_75219_a() {
                        return 1;
                    }

                    @NotNull
                    public ItemStack func_190901_a(PlayerEntity player, @NotNull ItemStack stack) {
                        return ItemStack.field_190927_a;
                    }

                    @NotNull
                    public ItemStack func_75209_a(int par1) {
                        return ItemStack.field_190927_a;
                    }

                    public boolean func_75214_a(ItemStack par1ItemStack) {
                        return false;
                    }

                    public boolean func_82869_a(PlayerEntity par1PlayerEntity) {
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 8 + i * 18, 142));
        }
        this.remainingItems = new ArrayList<ItemStack>();
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (!this.world.field_72995_K) {
            ServerPlayerEntity player = (ServerPlayerEntity)this.inv.field_70458_d;
            Optional iRecipe = ((ServerPlayerEntity)this.inv.field_70458_d).field_71133_b.func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, this.world);
            if (iRecipe.isPresent() && (((ICraftingRecipe)iRecipe.get()).func_192399_d() || !this.world.func_82736_K().func_223586_b(GameRules.field_223618_u) || player.func_192037_E().func_193830_f((IRecipe)iRecipe.get()) || player.func_184812_l_())) {
                ItemStack stack = ((ICraftingRecipe)iRecipe.get()).func_77572_b((IInventory)this.craftMatrix);
                this.craftResultSlot.func_75215_d(stack);
                player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, stack));
            } else {
                this.craftResultSlot.func_75215_d(ItemStack.field_190927_a);
                player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, ItemStack.field_190927_a));
            }
        }
        super.func_75130_a(inventoryIn);
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return true;
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int clickedButton, ClickType mode, PlayerEntity playerIn) {
        if (slotId >= 1 && slotId < 5 + (this.complete ? 5 : 0)) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                ItemStack dropping = playerIn.field_71071_by.func_70445_o();
                return this.handleSlotClick(slot, dropping);
            }
            return ItemStack.field_190927_a;
        }
        if (mode == ClickType.QUICK_MOVE) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, clickedButton, mode, playerIn);
    }

    public ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.func_190916_E() > 0) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            slot.func_75215_d(copy);
        } else if (slot.func_75211_c().func_190916_E() > 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return slot.func_75211_c().func_77946_l();
    }

    @NotNull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int total_crafting_slots = 5 + (this.complete ? 5 : 0);
        if (index <= total_crafting_slots) {
            return ItemStack.field_190927_a;
        }
        int total_slots = 41 + (this.complete ? 5 : 0);
        ItemStack itemstack = ItemStackUtils.EMPTY;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, total_crafting_slots, total_slots, true)) {
                    return ItemStackUtils.EMPTY;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index < 32) {
                if (!this.func_75135_a(itemstack1, 32, total_slots, false)) {
                    return ItemStackUtils.EMPTY;
                }
            } else if (index < total_slots && !this.func_75135_a(itemstack1, total_crafting_slots, 32, false) || !this.func_75135_a(itemstack1, total_crafting_slots, total_slots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStackUtils.EMPTY);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStackUtils.EMPTY;
            }
        }
        return itemstack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn != this.craftResultSlot && super.func_94530_a(stack, slotIn);
    }

    public World getWorldObj() {
        return this.world;
    }

    public PlayerEntity getPlayer() {
        return this.inv.field_70458_d;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public CraftingInventory getInv() {
        return this.craftMatrix;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public List<ItemStack> getRemainingItems() {
        Optional iRecipe = this.world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, this.world);
        if (iRecipe.isPresent()) {
            NonNullList ri = ((ICraftingRecipe)iRecipe.get()).func_179532_b((IInventory)this.craftMatrix);
            this.remainingItems.clear();
            for (int i = 0; i < ri.size(); ++i) {
                if (((ItemStack)ri.get(i)).func_190926_b()) continue;
                this.remainingItems.add((ItemStack)ri.get(i));
            }
        }
        return this.remainingItems;
    }

    public String getModuleId() {
        return this.moduleId;
    }
}

