/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.ImmutableItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorage {
    private final ItemStack stack;
    private final boolean shouldIgnoreDamageValue;
    private final boolean shouldIgnoreNBTValue;
    private final List<Integer> creativeTabIndex;
    private int amount;

    public ItemStorage(@NotNull ItemStack stack, int amount, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreDamageValue;
        this.amount = amount;
        this.creativeTabIndex = stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
        this.amount = ItemStackUtils.getSize(stack);
        this.creativeTabIndex = stack.func_190926_b() ? new ArrayList<Integer>() : stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
        this.creativeTabIndex = stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStorage(@NotNull ItemStack stack) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = false;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
        this.creativeTabIndex = stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStorage(@NotNull JsonObject jObject) {
        if (jObject.has("item")) {
            String matchType;
            ItemStack parsedStack = ItemStackUtils.idToItemStack(jObject.get("item").getAsString());
            if (jObject.has("count")) {
                parsedStack.func_190920_e(jObject.get("count").getAsInt());
                this.amount = jObject.get("count").getAsInt();
            } else {
                this.amount = parsedStack.func_190916_E();
            }
            this.stack = parsedStack;
            this.shouldIgnoreNBTValue = jObject.has("matchType") ? (matchType = jObject.get("matchType").getAsString()).equals("ignore") : false;
            this.shouldIgnoreDamageValue = true;
        } else {
            this.stack = ItemStack.field_190927_a;
            this.amount = 0;
            this.shouldIgnoreDamageValue = true;
            this.shouldIgnoreNBTValue = true;
        }
        this.creativeTabIndex = this.stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public static ItemStorage getItemStackOfListMatchingPredicate(List<ItemStorage> list, Predicate<ItemStack> predicate) {
        for (ItemStorage stack : list) {
            if (!predicate.test(stack.getItemStack())) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean ignoreDamageValue() {
        return this.shouldIgnoreDamageValue;
    }

    public boolean ignoreNBT() {
        return this.shouldIgnoreNBTValue;
    }

    public List<Integer> getCreativeTabIndex() {
        return this.creativeTabIndex;
    }

    public int getPrimaryCreativeTabIndex() {
        return this.creativeTabIndex.isEmpty() ? 0 : this.creativeTabIndex.get(0);
    }

    public String toString() {
        ItemStack stack = this.stack.func_77946_l();
        stack.func_190920_e(this.amount);
        return stack.toString();
    }

    public int hashCode() {
        return Objects.hash(this.stack.func_77973_b());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemStorage)) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return ItemStackUtils.compareItemStacksIgnoreStackSize(that.getItemStack(), this.getItemStack(), !this.shouldIgnoreDamageValue && !that.shouldIgnoreDamageValue, !this.shouldIgnoreNBTValue && !that.shouldIgnoreNBTValue);
    }

    public boolean matchDefinitionEquals(ItemStorage that) {
        return this.shouldIgnoreDamageValue == that.shouldIgnoreDamageValue && this.shouldIgnoreNBTValue == that.shouldIgnoreNBTValue;
    }

    @NotNull
    public Item getItem() {
        return this.stack.func_77973_b();
    }

    public int getDamageValue() {
        return this.stack.func_77952_i();
    }

    public int getRemainingDurablityValue() {
        return this.stack.func_77958_k() - this.stack.func_77952_i();
    }

    public boolean isEmpty() {
        return ItemStackUtils.isEmpty(this.stack) != false || this.amount <= 0;
    }

    public ItemStorage copy() {
        ItemStorage newInstance = new ItemStorage(this.stack.func_77946_l(), this.shouldIgnoreDamageValue, this.shouldIgnoreNBTValue);
        newInstance.setAmount(this.amount);
        return newInstance;
    }

    public ImmutableItemStorage toImmutable() {
        return new ImmutableItemStorage(this);
    }
}

