/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.tinkers;

import com.minecolonies.api.compatibility.tinkers.TinkersToolProxy;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public final class TinkersToolHelper
extends TinkersToolProxy {
    public static boolean isTinkersSword(@NotNull ItemStack stack) {
        return new TinkersToolHelper().isTinkersWeapon(stack);
    }

    @Override
    public boolean isTinkersWeapon(@NotNull ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && stack.func_77973_b().func_206844_a((ITag)TinkerTags.Items.SWORD);
    }

    @Override
    public double getAttackDamage(@NotNull ItemStack stack) {
        return ToolStack.from((ItemStack)stack).getStats().getFloat((IToolStat)ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public int getToolLevel(@NotNull ItemStack stack) {
        if (this.checkTinkersBroken(stack)) {
            return -1;
        }
        return ToolStack.from((ItemStack)stack).getStats().getInt((IToolStat)ToolStats.HARVEST_LEVEL);
    }

    public static double getDamage(@NotNull ItemStack stack) {
        return new TinkersToolHelper().getAttackDamage(stack);
    }

    public static int getToolLvl(@NotNull ItemStack stack) {
        return new TinkersToolHelper().getToolLevel(stack);
    }

    @Override
    public boolean checkTinkersBroken(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && ToolDamageUtil.isBroken((ItemStack)stack);
    }

    @Override
    public boolean isTinkersTool(@Nullable ItemStack stack, IToolType toolType) {
        if (ItemStackUtils.isEmpty(stack).booleanValue() || !stack.getToolTypes().contains(ToolType.get((String)toolType.getName()))) {
            return false;
        }
        return stack.func_77973_b().func_206844_a((ITag)TinkerTags.Items.HARVEST);
    }
}

